extends Resource
class_name NavigationMeshSourceGeometryData3D

## Container for parsed source geometry data used in navigation mesh baking.
##
## Container for parsed source geometry data used in navigation mesh baking.
## @experimental





## Adds an array of vertex positions to the geometry data for navigation mesh baking to form triangulated faces. For each face the array must have three vertex positions in clockwise winding order. Since [NavigationMesh] resources have no transform, all vertex positions need to be offset by the node's transform using [param xform].
func add_faces(faces: PackedVector3Array, xform: Transform3D) -> void:
	pass;

## Adds the geometry data of a [Mesh] resource to the navigation mesh baking data. The mesh must have valid triangulated mesh data to be considered. Since [NavigationMesh] resources have no transform, all vertex positions need to be offset by the node's transform using [param xform].
func add_mesh(mesh: Mesh, xform: Transform3D) -> void:
	pass;

## Adds an [Array] the size of [constant Mesh.ARRAY_MAX] and with vertices at index [constant Mesh.ARRAY_VERTEX] and indices at index [constant Mesh.ARRAY_INDEX] to the navigation mesh baking data. The array must have valid triangulated mesh data to be considered. Since [NavigationMesh] resources have no transform, all vertex positions need to be offset by the node's transform using [param xform].
func add_mesh_array(mesh_array: Array, xform: Transform3D) -> void:
	pass;

## Clears the internal data.
func clear() -> void:
	pass;

## Returns the parsed source geometry data indices array.
func get_indices() -> PackedInt32Array:
	pass;

## Returns the parsed source geometry data vertices array.
func get_vertices() -> PackedFloat32Array:
	pass;

## Returns [code]true[/code] when parsed source geometry data exists.
func has_data() -> bool:
	pass;

## Sets the parsed source geometry data indices. The indices need to be matched with appropriated vertices.
## [b]Warning:[/b] Inappropriate data can crash the baking process of the involved third-party libraries.
func set_indices(indices: PackedInt32Array) -> void:
	pass;

## Sets the parsed source geometry data vertices. The vertices need to be matched with appropriated indices.
## [b]Warning:[/b] Inappropriate data can crash the baking process of the involved third-party libraries.
func set_vertices(vertices: PackedFloat32Array) -> void:
	pass;


