extends Resource
class_name Mesh

## A [Resource] that contains vertex array-based geometry.
##
## Mesh is a type of [Resource] that contains vertex array-based geometry, divided in [i]surfaces[/i]. Each surface contains a completely separate array and a material used to draw it. Design wise, a mesh with multiple surfaces is preferred to a single surface, because objects created in 3D editing software commonly contain multiple materials.
##
## @tutorial(3D Material Testers Demo): https://godotengine.org/asset-library/asset/123
## @tutorial(3D Kinematic Character Demo): https://godotengine.org/asset-library/asset/126
## @tutorial(3D Platformer Demo): https://godotengine.org/asset-library/asset/125
## @tutorial(Third Person Shooter Demo): https://godotengine.org/asset-library/asset/678


## Render array as points (one vertex equals one point).
## Render array as lines (every two vertices a line is created).
## Render array as line strip.
## Render array as triangles (every three vertices a triangle is created).
## Render array as triangle strips.
## [PackedVector3Array], [PackedVector2Array], or [Array] of vertex positions.
## [PackedVector3Array] of vertex normals.
## [PackedFloat32Array] of vertex tangents. Each element in groups of 4 floats, first 3 floats determine the tangent, and the last the binormal direction as -1 or 1.
## [PackedColorArray] of vertex colors.
## [PackedVector2Array] for UV coordinates.
## [PackedVector2Array] for second UV coordinates.
## Contains custom color channel 0. [PackedByteArray] if [code](format >> Mesh.ARRAY_FORMAT_CUSTOM0_SHIFT) & Mesh.ARRAY_FORMAT_CUSTOM_MASK[/code] is [constant ARRAY_CUSTOM_RGBA8_UNORM], [constant ARRAY_CUSTOM_RGBA8_SNORM], [constant ARRAY_CUSTOM_RG_HALF], or [constant ARRAY_CUSTOM_RGBA_HALF]. [PackedFloat32Array] otherwise.
## Contains custom color channel 1. [PackedByteArray] if [code](format >> Mesh.ARRAY_FORMAT_CUSTOM1_SHIFT) & Mesh.ARRAY_FORMAT_CUSTOM_MASK[/code] is [constant ARRAY_CUSTOM_RGBA8_UNORM], [constant ARRAY_CUSTOM_RGBA8_SNORM], [constant ARRAY_CUSTOM_RG_HALF], or [constant ARRAY_CUSTOM_RGBA_HALF]. [PackedFloat32Array] otherwise.
## Contains custom color channel 2. [PackedByteArray] if [code](format >> Mesh.ARRAY_FORMAT_CUSTOM2_SHIFT) & Mesh.ARRAY_FORMAT_CUSTOM_MASK[/code] is [constant ARRAY_CUSTOM_RGBA8_UNORM], [constant ARRAY_CUSTOM_RGBA8_SNORM], [constant ARRAY_CUSTOM_RG_HALF], or [constant ARRAY_CUSTOM_RGBA_HALF]. [PackedFloat32Array] otherwise.
## Contains custom color channel 3. [PackedByteArray] if [code](format >> Mesh.ARRAY_FORMAT_CUSTOM3_SHIFT) & Mesh.ARRAY_FORMAT_CUSTOM_MASK[/code] is [constant ARRAY_CUSTOM_RGBA8_UNORM], [constant ARRAY_CUSTOM_RGBA8_SNORM], [constant ARRAY_CUSTOM_RG_HALF], or [constant ARRAY_CUSTOM_RGBA_HALF]. [PackedFloat32Array] otherwise.
## [PackedFloat32Array] or [PackedInt32Array] of bone indices. Contains either 4 or 8 numbers per vertex depending on the presence of the [constant ARRAY_FLAG_USE_8_BONE_WEIGHTS] flag.
## [PackedFloat32Array] or [PackedFloat64Array] of bone weights in the range [code]0.0[/code] to [code]1.0[/code] (inclusive). Contains either 4 or 8 numbers per vertex depending on the presence of the [constant ARRAY_FLAG_USE_8_BONE_WEIGHTS] flag.
## [PackedInt32Array] of integers used as indices referencing vertices, colors, normals, tangents, and textures. All of those arrays must have the same number of elements as the vertex array. No index can be beyond the vertex array size. When this index array is present, it puts the function into "index mode," where the index selects the [i]i[/i]'th vertex, normal, tangent, color, UV, etc. This means if you want to have different normals or colors along an edge, you have to duplicate the vertices.
## For triangles, the index array is interpreted as triples, referring to the vertices of each triangle. For lines, the index array is in pairs indicating the start and end of each line.
## Represents the size of the [enum ArrayType] enum.
## Indicates this custom channel contains unsigned normalized byte colors from 0 to 1, encoded as [PackedByteArray].
## Indicates this custom channel contains signed normalized byte colors from -1 to 1, encoded as [PackedByteArray].
## Indicates this custom channel contains half precision float colors, encoded as [PackedByteArray]. Only red and green channels are used.
## Indicates this custom channel contains half precision float colors, encoded as [PackedByteArray].
## Indicates this custom channel contains full float colors, in a [PackedFloat32Array]. Only the red channel is used.
## Indicates this custom channel contains full float colors, in a [PackedFloat32Array]. Only red and green channels are used.
## Indicates this custom channel contains full float colors, in a [PackedFloat32Array]. Only red, green and blue channels are used.
## Indicates this custom channel contains full float colors, in a [PackedFloat32Array].
## Represents the size of the [enum ArrayCustomFormat] enum.
## Mesh array contains vertices. All meshes require a vertex array so this should always be present.
## Mesh array contains normals.
## Mesh array contains tangents.
## Mesh array contains colors.
## Mesh array contains UVs.
## Mesh array contains second UV.
## Mesh array contains custom channel index 0.
## Mesh array contains custom channel index 1.
## Mesh array contains custom channel index 2.
## Mesh array contains custom channel index 3.
## Mesh array contains bones.
## Mesh array contains bone weights.
## Mesh array uses indices.
## Mask of mesh channels permitted in blend shapes.
## Shift of first custom channel.
## Number of format bits per custom channel. See [enum ArrayCustomFormat].
## Amount to shift [enum ArrayCustomFormat] for custom channel index 0.
## Amount to shift [enum ArrayCustomFormat] for custom channel index 1.
## Amount to shift [enum ArrayCustomFormat] for custom channel index 2.
## Amount to shift [enum ArrayCustomFormat] for custom channel index 3.
## Mask of custom format bits per custom channel. Must be shifted by one of the SHIFT constants. See [enum ArrayCustomFormat].
## Shift of first compress flag. Compress flags should be passed to [method ArrayMesh.add_surface_from_arrays] and [method SurfaceTool.commit].
## Flag used to mark that the array contains 2D vertices.
## Flag indices that the mesh data will use [code]GL_DYNAMIC_DRAW[/code] on GLES. Unused on Vulkan.
## Flag used to mark that the mesh contains up to 8 bone influences per vertex. This flag indicates that [constant ARRAY_BONES] and [constant ARRAY_WEIGHTS] elements will have double length.
## Flag used to mark that the mesh intentionally contains no vertex array.
## Flag used to mark that a mesh is using compressed attributes (vertices, normals, tangents, UVs). When this form of compression is enabled, vertex positions will be packed into an RGBA16UNORM attribute and scaled in the vertex shader. The normal and tangent will be packed into an RG16UNORM representing an axis, and a 16-bit float stored in the A-channel of the vertex. UVs will use 16-bit normalized floats instead of full 32-bit signed floats. When using this compression mode you must use either vertices, normals, and tangents or only vertices. You cannot use normals without tangents. Importers will automatically enable this compression if they can.
## Blend shapes are normalized.
## Blend shapes are relative to base weight.

#enum PrimitiveType
enum {
    PRIMITIVE_POINTS = 0,
    PRIMITIVE_LINES = 1,
    PRIMITIVE_LINE_STRIP = 2,
    PRIMITIVE_TRIANGLES = 3,
    PRIMITIVE_TRIANGLE_STRIP = 4,
}
#enum ArrayType
enum {
    ARRAY_VERTEX = 0,
    ARRAY_NORMAL = 1,
    ARRAY_TANGENT = 2,
    ARRAY_COLOR = 3,
    ARRAY_TEX_UV = 4,
    ARRAY_TEX_UV2 = 5,
    ARRAY_CUSTOM0 = 6,
    ARRAY_CUSTOM1 = 7,
    ARRAY_CUSTOM2 = 8,
    ARRAY_CUSTOM3 = 9,
    ARRAY_BONES = 10,
    ARRAY_WEIGHTS = 11,
    ARRAY_INDEX = 12,
    ARRAY_MAX = 13,
}
#enum ArrayCustomFormat
enum {
    ARRAY_CUSTOM_RGBA8_UNORM = 0,
    ARRAY_CUSTOM_RGBA8_SNORM = 1,
    ARRAY_CUSTOM_RG_HALF = 2,
    ARRAY_CUSTOM_RGBA_HALF = 3,
    ARRAY_CUSTOM_R_FLOAT = 4,
    ARRAY_CUSTOM_RG_FLOAT = 5,
    ARRAY_CUSTOM_RGB_FLOAT = 6,
    ARRAY_CUSTOM_RGBA_FLOAT = 7,
    ARRAY_CUSTOM_MAX = 8,
}
#enum ArrayFormat
enum {
    ARRAY_FORMAT_VERTEX = 1,
    ARRAY_FORMAT_NORMAL = 2,
    ARRAY_FORMAT_TANGENT = 4,
    ARRAY_FORMAT_COLOR = 8,
    ARRAY_FORMAT_TEX_UV = 16,
    ARRAY_FORMAT_TEX_UV2 = 32,
    ARRAY_FORMAT_CUSTOM0 = 64,
    ARRAY_FORMAT_CUSTOM1 = 128,
    ARRAY_FORMAT_CUSTOM2 = 256,
    ARRAY_FORMAT_CUSTOM3 = 512,
    ARRAY_FORMAT_BONES = 1024,
    ARRAY_FORMAT_WEIGHTS = 2048,
    ARRAY_FORMAT_INDEX = 4096,
    ARRAY_FORMAT_BLEND_SHAPE_MASK = 7,
    ARRAY_FORMAT_CUSTOM_BASE = 13,
    ARRAY_FORMAT_CUSTOM_BITS = 3,
    ARRAY_FORMAT_CUSTOM0_SHIFT = 13,
    ARRAY_FORMAT_CUSTOM1_SHIFT = 16,
    ARRAY_FORMAT_CUSTOM2_SHIFT = 19,
    ARRAY_FORMAT_CUSTOM3_SHIFT = 22,
    ARRAY_FORMAT_CUSTOM_MASK = 7,
    ARRAY_COMPRESS_FLAGS_BASE = 25,
    ARRAY_FLAG_USE_2D_VERTICES = 33554432,
    ARRAY_FLAG_USE_DYNAMIC_UPDATE = 67108864,
    ARRAY_FLAG_USE_8_BONE_WEIGHTS = 134217728,
    ARRAY_FLAG_USES_EMPTY_VERTEX_ARRAY = 268435456,
    ARRAY_FLAG_COMPRESS_ATTRIBUTES = 536870912,
}
#enum BlendShapeMode
enum {
    BLEND_SHAPE_MODE_NORMALIZED = 0,
    BLEND_SHAPE_MODE_RELATIVE = 1,
}
## Sets a hint to be used for lightmap resolution.
var lightmap_size_hint: Vector2i:
	get = get_lightmap_size_hint, set = set_lightmap_size_hint



## Virtual method to override the [AABB] for a custom class extending [Mesh].
func _get_aabb() -> AABB:
	pass;

## Virtual method to override the number of blend shapes for a custom class extending [Mesh].
func _get_blend_shape_count() -> int:
	pass;

## Virtual method to override the retrieval of blend shape names for a custom class extending [Mesh].
func _get_blend_shape_name(index: int) -> StringName:
	pass;

## Virtual method to override the surface count for a custom class extending [Mesh].
func _get_surface_count() -> int:
	pass;

## Virtual method to override the names of blend shapes for a custom class extending [Mesh].
func _set_blend_shape_name(index: int, name: StringName) -> void:
	pass;

## Virtual method to override the surface array index length for a custom class extending [Mesh].
func _surface_get_array_index_len(index: int) -> int:
	pass;

## Virtual method to override the surface array length for a custom class extending [Mesh].
func _surface_get_array_len(index: int) -> int:
	pass;

## Virtual method to override the surface arrays for a custom class extending [Mesh].
func _surface_get_arrays(index: int) -> Array:
	pass;

## Virtual method to override the blend shape arrays for a custom class extending [Mesh].
func _surface_get_blend_shape_arrays(index: int) -> Array[Array]:
	pass;

## Virtual method to override the surface format for a custom class extending [Mesh].
func _surface_get_format(index: int) -> int:
	pass;

## Virtual method to override the surface LODs for a custom class extending [Mesh].
func _surface_get_lods(index: int) -> Dictionary:
	pass;

## Virtual method to override the surface material for a custom class extending [Mesh].
func _surface_get_material(index: int) -> Material:
	pass;

## Virtual method to override the surface primitive type for a custom class extending [Mesh].
func _surface_get_primitive_type(index: int) -> int:
	pass;

## Virtual method to override the setting of a [param material] at the given [param index] for a custom class extending [Mesh].
func _surface_set_material(index: int, material: Material) -> void:
	pass;

## Calculate a [ConvexPolygonShape3D] from the mesh.
## If [param clean] is [code]true[/code] (default), duplicate and interior vertices are removed automatically. You can set it to [code]false[/code] to make the process faster if not needed.
## If [param simplify] is [code]true[/code], the geometry can be further simplified to reduce the number of vertices. Disabled by default.
func create_convex_shape(clean: bool = true, simplify: bool = false) -> ConvexPolygonShape3D:
	pass;

## Calculate an outline mesh at a defined offset (margin) from the original mesh.
## [b]Note:[/b] This method typically returns the vertices in reverse order (e.g. clockwise to counterclockwise).
func create_outline(margin: float) -> Mesh:
	pass;

## Creates a placeholder version of this resource ([PlaceholderMesh]).
func create_placeholder() -> Resource:
	pass;

## Calculate a [ConcavePolygonShape3D] from the mesh.
func create_trimesh_shape() -> ConcavePolygonShape3D:
	pass;

## Generate a [TriangleMesh] from the mesh. Considers only surfaces using one of these primitive types: [constant PRIMITIVE_TRIANGLES], [constant PRIMITIVE_TRIANGLE_STRIP].
func generate_triangle_mesh() -> TriangleMesh:
	pass;

## Returns the smallest [AABB] enclosing this mesh in local space. Not affected by [code]custom_aabb[/code].
## [b]Note:[/b] This is only implemented for [ArrayMesh] and [PrimitiveMesh].
func get_aabb() -> AABB:
	pass;

## Returns all the vertices that make up the faces of the mesh. Each three vertices represent one triangle.
func get_faces() -> PackedVector3Array:
	pass;

## Returns the number of surfaces that the [Mesh] holds. This is equivalent to [method MeshInstance3D.get_surface_override_material_count].
func get_surface_count() -> int:
	pass;

## Returns the arrays for the vertices, normals, UVs, etc. that make up the requested surface (see [method ArrayMesh.add_surface_from_arrays]).
func surface_get_arrays(surf_idx: int) -> Array:
	pass;

## Returns the blend shape arrays for the requested surface.
func surface_get_blend_shape_arrays(surf_idx: int) -> Array[Array]:
	pass;

## Returns a [Material] in a given surface. Surface is rendered using this material.
## [b]Note:[/b] This returns the material within the [Mesh] resource, not the [Material] associated to the [MeshInstance3D]'s Surface Material Override properties. To get the [Material] associated to the [MeshInstance3D]'s Surface Material Override properties, use [method MeshInstance3D.get_surface_override_material] instead.
func surface_get_material(surf_idx: int) -> Material:
	pass;

## Sets a [Material] for a given surface. Surface will be rendered using this material.
## [b]Note:[/b] This assigns the material within the [Mesh] resource, not the [Material] associated to the [MeshInstance3D]'s Surface Material Override properties. To set the [Material] associated to the [MeshInstance3D]'s Surface Material Override properties, use [method MeshInstance3D.set_surface_override_material] instead.
func surface_set_material(surf_idx: int, material: Material) -> void:
	pass;


func get_lightmap_size_hint() -> Vector2i:
	return lightmap_size_hint

func set_lightmap_size_hint(value: Vector2i) -> void:
	lightmap_size_hint = value

