extends Node2D
class_name Line2D

## A 2D polyline that can optionally be textured.
##
## This node draws a 2D polyline, i.e. a shape consisting of several points connected by segments. [Line2D] is not a mathematical polyline, i.e. the segments are not infinitely thin. It is intended for rendering and it can be colored and optionally textured.
## [b]Warning:[/b] Certain configurations may be impossible to draw nicely, such as very sharp angles. In these situations, the node uses fallback drawing logic to look decent.
## [b]Note:[/b] [Line2D] is drawn using a 2D mesh.
##
## @tutorial(Matrix Transform Demo): https://godotengine.org/asset-library/asset/584
## @tutorial(2.5D Demo): https://godotengine.org/asset-library/asset/583


## Makes the polyline's joints pointy, connecting the sides of the two segments by extending them until they intersect. If the rotation of a joint is too big (based on [member sharp_limit]), the joint falls back to [constant LINE_JOINT_BEVEL] to prevent very long miters.
## Makes the polyline's joints bevelled/chamfered, connecting the sides of the two segments with a simple line.
## Makes the polyline's joints rounded, connecting the sides of the two segments with an arc. The detail of this arc depends on [member round_precision].
## Draws no line cap.
## Draws the line cap as a box, slightly extending the first/last segment.
## Draws the line cap as a semicircle attached to the first/last segment.
## Takes the left pixels of the texture and renders them over the whole polyline.
## Tiles the texture over the polyline. [member CanvasItem.texture_repeat] of the [Line2D] node must be [constant CanvasItem.TEXTURE_REPEAT_ENABLED] or [constant CanvasItem.TEXTURE_REPEAT_MIRROR] for it to work properly.
## Stretches the texture across the polyline. [member CanvasItem.texture_repeat] of the [Line2D] node must be [constant CanvasItem.TEXTURE_REPEAT_DISABLED] for best results.

#enum LineJointMode
enum {
    LINE_JOINT_SHARP = 0,
    LINE_JOINT_BEVEL = 1,
    LINE_JOINT_ROUND = 2,
}
#enum LineCapMode
enum {
    LINE_CAP_NONE = 0,
    LINE_CAP_BOX = 1,
    LINE_CAP_ROUND = 2,
}
#enum LineTextureMode
enum {
    LINE_TEXTURE_NONE = 0,
    LINE_TEXTURE_TILE = 1,
    LINE_TEXTURE_STRETCH = 2,
}
## If [code]true[/code], the polyline's border will be anti-aliased.
## [b]Note:[/b] [Line2D] is not accelerated by batching when being anti-aliased.
var antialiased: bool:
	get = get_antialiased, set = set_antialiased

## The style of the beginning of the polyline, if [member closed] is [code]false[/code]. Use [enum LineCapMode] constants.
var begin_cap_mode: int:
	get = get_begin_cap_mode, set = set_begin_cap_mode

## If [code]true[/code] and the polyline has more than 2 points, the last point and the first one will be connected by a segment.
## [b]Note:[/b] The shape of the closing segment is not guaranteed to be seamless if a [member width_curve] is provided.
## [b]Note:[/b] The joint between the closing segment and the first segment is drawn first and it samples the [member gradient] and the [member width_curve] at the beginning. This is an implementation detail that might change in a future version.
var closed: bool:
	get = is_closed, set = set_closed

## The color of the polyline. Will not be used if a gradient is set.
var default_color: Color:
	get = get_default_color, set = set_default_color

## The style of the end of the polyline, if [member closed] is [code]false[/code]. Use [enum LineCapMode] constants.
var end_cap_mode: int:
	get = get_end_cap_mode, set = set_end_cap_mode

## The gradient is drawn through the whole line from start to finish. The [member default_color] will not be used if this property is set.
var gradient: Gradient:
	get = get_gradient, set = set_gradient

## The style of the connections between segments of the polyline. Use [enum LineJointMode] constants.
var joint_mode: int:
	get = get_joint_mode, set = set_joint_mode

## The points of the polyline, interpreted in local 2D coordinates. Segments are drawn between the adjacent points in this array.
var points: PackedVector2Array:
	get = get_points, set = set_points

## The smoothness used for rounded joints and caps. Higher values result in smoother corners, but are more demanding to render and update.
var round_precision: int:
	get = get_round_precision, set = set_round_precision

## Determines the miter limit of the polyline. Normally, when [member joint_mode] is set to [constant LINE_JOINT_SHARP], sharp angles fall back to using the logic of [constant LINE_JOINT_BEVEL] joints to prevent very long miters. Higher values of this property mean that the fallback to a bevel joint will happen at sharper angles.
var sharp_limit: float:
	get = get_sharp_limit, set = set_sharp_limit

## The texture used for the polyline. Uses [member texture_mode] for drawing style.
var texture: Texture2D:
	get = get_texture, set = set_texture

## The style to render the [member texture] of the polyline. Use [enum LineTextureMode] constants.
var texture_mode: int:
	get = get_texture_mode, set = set_texture_mode

## The polyline's width.
var width: float:
	get = get_width, set = set_width

## The polyline's width curve. The width of the polyline over its length will be equivalent to the value of the width curve over its domain.
var width_curve: Curve:
	get = get_curve, set = set_curve



## Adds a point with the specified [param position] relative to the polyline's own position. If no [param index] is provided, the new point will be added to the end of the points array.
## If [param index] is given, the new point is inserted before the existing point identified by index [param index]. The indices of the points after the new point get increased by 1. The provided [param index] must not exceed the number of existing points in the polyline. See [method get_point_count].
func add_point(position: Vector2, index: int = -1) -> void:
	pass;

## Removes all points from the polyline, making it empty.
func clear_points() -> void:
	pass;

## Returns the number of points in the polyline.
func get_point_count() -> int:
	pass;

## Returns the position of the point at index [param index].
func get_point_position(index: int) -> Vector2:
	pass;

## Removes the point at index [param index] from the polyline.
func remove_point(index: int) -> void:
	pass;

## Overwrites the position of the point at the given [param index] with the supplied [param position].
func set_point_position(index: int, position: Vector2) -> void:
	pass;


func get_antialiased() -> bool:
	return antialiased

func set_antialiased(value: bool) -> void:
	antialiased = value

func get_begin_cap_mode() -> int:
	return begin_cap_mode

func set_begin_cap_mode(value: int) -> void:
	begin_cap_mode = value

func is_closed() -> bool:
	return closed

func set_closed(value: bool) -> void:
	closed = value

func get_default_color() -> Color:
	return default_color

func set_default_color(value: Color) -> void:
	default_color = value

func get_end_cap_mode() -> int:
	return end_cap_mode

func set_end_cap_mode(value: int) -> void:
	end_cap_mode = value

func get_gradient() -> Gradient:
	return gradient

func set_gradient(value: Gradient) -> void:
	gradient = value

func get_joint_mode() -> int:
	return joint_mode

func set_joint_mode(value: int) -> void:
	joint_mode = value

func get_points() -> PackedVector2Array:
	return points

func set_points(value: PackedVector2Array) -> void:
	points = value

func get_round_precision() -> int:
	return round_precision

func set_round_precision(value: int) -> void:
	round_precision = value

func get_sharp_limit() -> float:
	return sharp_limit

func set_sharp_limit(value: float) -> void:
	sharp_limit = value

func get_texture() -> Texture2D:
	return texture

func set_texture(value: Texture2D) -> void:
	texture = value

func get_texture_mode() -> int:
	return texture_mode

func set_texture_mode(value: int) -> void:
	texture_mode = value

func get_width() -> float:
	return width

func set_width(value: float) -> void:
	width = value

func get_curve() -> Curve:
	return width_curve

func set_curve(value: Curve) -> void:
	width_curve = value

