extends EditorResourcePicker
class_name EditorScriptPicker

## Godot editor's control for selecting the [code]script[/code] property of a [Node].
##
## Similar to [EditorResourcePicker] this [Control] node is used in the editor's Inspector dock, but only to edit the [code]script[/code] property of a [Node]. Default options for creating new resources of all possible subtypes are replaced with dedicated buttons that open the "Attach Node Script" dialog. Can be used with [EditorInspectorPlugin] to recreate the same behavior.
## [b]Note:[/b] You must set the [member script_owner] for the custom context menu items to work.



## The owner [Node] of the script property that holds the edited resource.
var script_owner: Node:
	get = get_script_owner, set = set_script_owner




func get_script_owner() -> Node:
	return script_owner

func set_script_owner(value: Node) -> void:
	script_owner = value

