extends BaseButton
class_name Button

## A themed button that can contain text and an icon.
##
## [Button] is the standard themed button. It can contain text and an icon, and it will display them according to the current [Theme].
## [b]Example of creating a button and assigning an action when pressed by code:[/b]
## [codeblocks]
## [gdscript]
## func _ready():
## var button = Button.new()
## button.text = "Click me"
## button.pressed.connect(self._button_pressed)
## add_child(button)
## func _button_pressed():
## print("Hello world!")
## [/gdscript]
## [csharp]
## public override void _Ready()
## {
## var button = new Button();
## button.Text = "Click me";
## button.Pressed += ButtonPressed;
## AddChild(button);
## }
## private void ButtonPressed()
## {
## GD.Print("Hello world!");
## }
## [/csharp]
## [/codeblocks]
## See also [BaseButton] which contains common properties and methods associated with this node.
## [b]Note:[/b] Buttons do not interpret touch input and therefore don't support multitouch, since mouse emulation can only press one button at a given time. Use [TouchScreenButton] for buttons that trigger gameplay movement or actions.
##
## @tutorial(2D Dodge The Creeps Demo): https://godotengine.org/asset-library/asset/515
## @tutorial(OS Test Demo): https://godotengine.org/asset-library/asset/677



## Text alignment policy for the button's text, use one of the [enum HorizontalAlignment] constants.
var alignment: int:
	get = get_text_alignment, set = set_text_alignment

## When this property is enabled, text that is too large to fit the button is clipped, when disabled the Button will always be wide enough to hold the text.
var clip_text: bool:
	get = get_clip_text, set = set_clip_text

## When enabled, the button's icon will expand/shrink to fit the button's size while keeping its aspect. See also [theme_item icon_max_width].
var expand_icon: bool:
	get = is_expand_icon, set = set_expand_icon

## Flat buttons don't display decoration.
var flat: bool:
	get = is_flat, set = set_flat

## Button's icon, if text is present the icon will be placed before the text.
## To edit margin and spacing of the icon, use [theme_item h_separation] theme property and [code]content_margin_*[/code] properties of the used [StyleBox]es.
var icon: Texture2D:
	get = get_button_icon, set = set_button_icon

## Specifies if the icon should be aligned horizontally to the left, right, or center of a button. Uses the same [enum HorizontalAlignment] constants as the text alignment. If centered horizontally and vertically, text will draw on top of the icon.
var icon_alignment: int:
	get = get_icon_alignment, set = set_icon_alignment

## Language code used for line-breaking and text shaping algorithms, if left empty current locale is used instead.
var language: String:
	get = get_language, set = set_language

## The button's text that will be displayed inside the button's area.
var text: String:
	get = get_text, set = set_text

## Base text writing direction.
var text_direction: int:
	get = get_text_direction, set = set_text_direction

## Sets the clipping behavior when the text exceeds the node's bounding rectangle. See [enum TextServer.OverrunBehavior] for a description of all modes.
var text_overrun_behavior: int:
	get = get_text_overrun_behavior, set = set_text_overrun_behavior

## Specifies if the icon should be aligned vertically to the top, bottom, or center of a button. Uses the same [enum VerticalAlignment] constants as the text alignment. If centered horizontally and vertically, text will draw on top of the icon.
var vertical_icon_alignment: int:
	get = get_vertical_icon_alignment, set = set_vertical_icon_alignment




func get_text_alignment() -> int:
	return alignment

func set_text_alignment(value: int) -> void:
	alignment = value

func get_clip_text() -> bool:
	return clip_text

func set_clip_text(value: bool) -> void:
	clip_text = value

func is_expand_icon() -> bool:
	return expand_icon

func set_expand_icon(value: bool) -> void:
	expand_icon = value

func is_flat() -> bool:
	return flat

func set_flat(value: bool) -> void:
	flat = value

func get_button_icon() -> Texture2D:
	return icon

func set_button_icon(value: Texture2D) -> void:
	icon = value

func get_icon_alignment() -> int:
	return icon_alignment

func set_icon_alignment(value: int) -> void:
	icon_alignment = value

func get_language() -> String:
	return language

func set_language(value: String) -> void:
	language = value

func get_text() -> String:
	return text

func set_text(value: String) -> void:
	text = value

func get_text_direction() -> int:
	return text_direction

func set_text_direction(value: int) -> void:
	text_direction = value

func get_text_overrun_behavior() -> int:
	return text_overrun_behavior

func set_text_overrun_behavior(value: int) -> void:
	text_overrun_behavior = value

func get_vertical_icon_alignment() -> int:
	return vertical_icon_alignment

func set_vertical_icon_alignment(value: int) -> void:
	vertical_icon_alignment = value

