class_name Array

## A built-in data structure that holds a sequence of elements.
##
## An array data structure that can contain a sequence of elements of any type. Elements are accessed by a numerical index starting at 0. Negative indices are used to count from the back (-1 is the last element, -2 is the second to last, etc.).
## [b]Example:[/b]
## [codeblocks]
## [gdscript]
## var array = ["One", 2, 3, "Four"]
## print(array[0]) # One.
## print(array[2]) # 3.
## print(array[-1]) # Four.
## array[2] = "Three"
## print(array[-2]) # Three.
## [/gdscript]
## [csharp]
## var array = new Godot.Collections.Array{"One", 2, 3, "Four"};
## GD.Print(array[0]); // One.
## GD.Print(array[2]); // 3.
## GD.Print(array[array.Count - 1]); // Four.
## array[2] = "Three";
## GD.Print(array[array.Count - 2]); // Three.
## [/csharp]
## [/codeblocks]
## Arrays can be concatenated using the [code]+[/code] operator:
## [codeblocks]
## [gdscript]
## var array1 = ["One", 2]
## var array2 = [3, "Four"]
## print(array1 + array2) # ["One", 2, 3, "Four"]
## [/gdscript]
## [csharp]
## // Array concatenation is not possible with C# arrays, but is with Godot.Collections.Array.
## var array1 = new Godot.Collections.Array{"One", 2};
## var array2 = new Godot.Collections.Array{3, "Four"};
## GD.Print(array1 + array2); // Prints [One, 2, 3, Four]
## [/csharp]
## [/codeblocks]
## [b]Note:[/b] Arrays are always passed by reference. To get a copy of an array that can be modified independently of the original array, use [method duplicate].
## [b]Note:[/b] Erasing elements while iterating over arrays is [b]not[/b] supported and will result in unpredictable behavior.




## Constructs an empty [Array].
func Array() -> Array:
	pass;

## Creates a typed array from the [param base] array. All arguments are required.
## - [param type] is the built-in type as a [enum Variant.Type] constant, for example [constant TYPE_INT].
## - [param class_name] is the [b]native[/b] class name, for example [Node]. If [param type] is not [constant TYPE_OBJECT], must be an empty string.
## - [param script] is the associated script. Must be a [Script] instance or [code]null[/code].
## Examples:
## [codeblock]
## class_name MyNode
## extends Node
## class MyClass:
## pass
## func _ready():
## var a = Array([], TYPE_INT, &"", null) # Array[int]
## var b = Array([], TYPE_OBJECT, &"Node", null) # Array[Node]
## var c = Array([], TYPE_OBJECT, &"Node", MyNode) # Array[MyNode]
## var d = Array([], TYPE_OBJECT, &"RefCounted", MyClass) # Array[MyClass]
## [/codeblock]
## [b]Note:[/b] This constructor can be useful if you want to create a typed array on the fly, but you are not required to use it. In GDScript you can use a temporary variable with the static type you need and then pass it:
## [codeblock]
## func _ready():
## var a: Array[int] = []
## some_func(a)
## [/codeblock]
func Array(base: Array, type: int, class_name: StringName, script: Variant) -> Array:
	pass;

## Returns the same array as [param from]. If you need a copy of the array, use [method duplicate].
func Array(from: Array) -> Array:
	pass;

## Constructs an array from a [PackedByteArray].
func Array(from: PackedByteArray) -> Array:
	pass;

## Constructs an array from a [PackedColorArray].
func Array(from: PackedColorArray) -> Array:
	pass;

## Constructs an array from a [PackedFloat32Array].
func Array(from: PackedFloat32Array) -> Array:
	pass;

## Constructs an array from a [PackedFloat64Array].
func Array(from: PackedFloat64Array) -> Array:
	pass;

## Constructs an array from a [PackedInt32Array].
func Array(from: PackedInt32Array) -> Array:
	pass;

## Constructs an array from a [PackedInt64Array].
func Array(from: PackedInt64Array) -> Array:
	pass;

## Constructs an array from a [PackedStringArray].
func Array(from: PackedStringArray) -> Array:
	pass;

## Constructs an array from a [PackedVector2Array].
func Array(from: PackedVector2Array) -> Array:
	pass;

## Constructs an array from a [PackedVector3Array].
func Array(from: PackedVector3Array) -> Array:
	pass;


## Calls the provided [Callable] on each element in the array and returns [code]true[/code] if the [Callable] returns [code]true[/code] for [i]all[/i] elements in the array. If the [Callable] returns [code]false[/code] for one array element or more, this method returns [code]false[/code].
## The callable's method should take one [Variant] parameter (the current array element) and return a boolean value.
## [codeblock]
## func _ready():
## print([6, 10, 6].all(greater_than_5))  # Prints True (3/3 elements evaluate to `true`).
## print([4, 10, 4].all(greater_than_5))  # Prints False (1/3 elements evaluate to `true`).
## print([4, 4, 4].all(greater_than_5))  # Prints False (0/3 elements evaluate to `true`).
## print([].all(greater_than_5))  # Prints True (0/0 elements evaluate to `true`).
## print([6, 10, 6].all(func(number): return number > 5))  # Prints True. Same as the first line above, but using lambda function.
## func greater_than_5(number):
## return number > 5
## [/codeblock]
## See also [method any], [method filter], [method map] and [method reduce].
## [b]Note:[/b] Unlike relying on the size of an array returned by [method filter], this method will return as early as possible to improve performance (especially with large arrays).
## [b]Note:[/b] For an empty array, this method [url=https://en.wikipedia.org/wiki/Vacuous_truth]always[/url] returns [code]true[/code].
func all(method: Callable) -> bool:
	pass;

## Calls the provided [Callable] on each element in the array and returns [code]true[/code] if the [Callable] returns [code]true[/code] for [i]one or more[/i] elements in the array. If the [Callable] returns [code]false[/code] for all elements in the array, this method returns [code]false[/code].
## The callable's method should take one [Variant] parameter (the current array element) and return a boolean value.
## [codeblock]
## func _ready():
## print([6, 10, 6].any(greater_than_5))  # Prints True (3 elements evaluate to `true`).
## print([4, 10, 4].any(greater_than_5))  # Prints True (1 elements evaluate to `true`).
## print([4, 4, 4].any(greater_than_5))  # Prints False (0 elements evaluate to `true`).
## print([].any(greater_than_5))  # Prints False (0 elements evaluate to `true`).
## print([6, 10, 6].any(func(number): return number > 5))  # Prints True. Same as the first line above, but using lambda function.
## func greater_than_5(number):
## return number > 5
## [/codeblock]
## See also [method all], [method filter], [method map] and [method reduce].
## [b]Note:[/b] Unlike relying on the size of an array returned by [method filter], this method will return as early as possible to improve performance (especially with large arrays).
## [b]Note:[/b] For an empty array, this method always returns [code]false[/code].
func any(method: Callable) -> bool:
	pass;

## Appends an element at the end of the array (alias of [method push_back]).
func append(value: Variant) -> void:
	pass;

## Appends another array at the end of this array.
## [codeblock]
## var array1 = [1, 2, 3]
## var array2 = [4, 5, 6]
## array1.append_array(array2)
## print(array1) # Prints [1, 2, 3, 4, 5, 6].
## [/codeblock]
func append_array(array: Array) -> void:
	pass;

## Assigns elements of another [param array] into the array. Resizes the array to match [param array]. Performs type conversions if the array is typed.
func assign(array: Array) -> void:
	pass;

## Returns the last element of the array. Prints an error and returns [code]null[/code] if the array is empty.
## [b]Note:[/b] Calling this function is not the same as writing [code]array[-1][/code]. If the array is empty, accessing by index will pause project execution when running from the editor.
func back() -> Variant:
	pass;

## Finds the index of an existing value (or the insertion index that maintains sorting order, if the value is not yet present in the array) using binary search. Optionally, a [param before] specifier can be passed. If [code]false[/code], the returned index comes after all existing entries of the value in the array.
## [codeblock]
## var array = ["a", "b", "c", "c", "d", "e"]
## print(array.bsearch("c", true))  # Prints 2, at the first matching element.
## print(array.bsearch("c", false)) # Prints 4, after the last matching element, pointing to "d".
## [/codeblock]
## [b]Note:[/b] Calling [method bsearch] on an unsorted array results in unexpected behavior.
func bsearch(value: Variant, before: bool = true) -> int:
	pass;

## Finds the index of an existing value (or the insertion index that maintains sorting order, if the value is not yet present in the array) using binary search and a custom comparison method. Optionally, a [param before] specifier can be passed. If [code]false[/code], the returned index comes after all existing entries of the value in the array. The custom method receives two arguments (an element from the array and the value searched for) and must return [code]true[/code] if the first argument is less than the second, and return [code]false[/code] otherwise.
## [b]Note:[/b] The custom method must accept the two arguments in any order, you cannot rely on that the first argument will always be from the array.
## [b]Note:[/b] Calling [method bsearch_custom] on an unsorted array results in unexpected behavior.
func bsearch_custom(value: Variant, func: Callable, before: bool = true) -> int:
	pass;

## Clears the array. This is equivalent to using [method resize] with a size of [code]0[/code].
func clear() -> void:
	pass;

## Returns the number of times an element is in the array.
func count(value: Variant) -> int:
	pass;

## Returns a copy of the array.
## If [param deep] is [code]true[/code], a deep copy is performed: all nested arrays and dictionaries are duplicated and will not be shared with the original array. If [code]false[/code], a shallow copy is made and references to the original nested arrays and dictionaries are kept, so that modifying a sub-array or dictionary in the copy will also impact those referenced in the source array. Note that any [Object]-derived elements will be shallow copied regardless of the [param deep] setting.
func duplicate(deep: bool = false) -> Array:
	pass;

## Removes the first occurrence of a value from the array. If the value does not exist in the array, nothing happens. To remove an element by index, use [method remove_at] instead.
## [b]Note:[/b] This method acts in-place and doesn't return a modified array.
## [b]Note:[/b] On large arrays, this method will be slower if the removed element is close to the beginning of the array (index 0). This is because all elements placed after the removed element have to be reindexed.
## [b]Note:[/b] Do not erase entries while iterating over the array.
func erase(value: Variant) -> void:
	pass;

## Assigns the given value to all elements in the array. This can typically be used together with [method resize] to create an array with a given size and initialized elements:
## [codeblocks]
## [gdscript]
## var array = []
## array.resize(10)
## array.fill(0) # Initialize the 10 elements to 0.
## [/gdscript]
## [csharp]
## var array = new Godot.Collections.Array();
## array.Resize(10);
## array.Fill(0); // Initialize the 10 elements to 0.
## [/csharp]
## [/codeblocks]
## [b]Note:[/b] If [param value] is of a reference type ([Object]-derived, [Array], [Dictionary], etc.) then the array is filled with the references to the same object, i.e. no duplicates are created.
func fill(value: Variant) -> void:
	pass;

## Calls the provided [Callable] on each element in the array and returns a new array with the elements for which the method returned [code]true[/code].
## The callable's method should take one [Variant] parameter (the current array element) and return a boolean value.
## [codeblock]
## func _ready():
## print([1, 2, 3].filter(remove_1)) # Prints [2, 3].
## print([1, 2, 3].filter(func(number): return number != 1)) # Same as above, but using lambda function.
## func remove_1(number):
## return number != 1
## [/codeblock]
## See also [method any], [method all], [method map] and [method reduce].
func filter(method: Callable) -> Array:
	pass;

## Searches the array for a value and returns its index or [code]-1[/code] if not found. Optionally, the initial search index can be passed.
func find(what: Variant, from: int = 0) -> int:
	pass;

## Returns the first element of the array. Prints an error and returns [code]null[/code] if the array is empty.
## [b]Note:[/b] Calling this function is not the same as writing [code]array[0][/code]. If the array is empty, accessing by index will pause project execution when running from the editor.
func front() -> Variant:
	pass;

## Returns the built-in type of the typed array as a [enum Variant.Type] constant. If the array is not typed, returns [constant TYPE_NIL].
func get_typed_builtin() -> int:
	pass;

## Returns the [b]native[/b] class name of the typed array if the built-in type is [constant TYPE_OBJECT]. Otherwise, this method returns an empty string.
func get_typed_class_name() -> StringName:
	pass;

## Returns the script associated with the typed array. This method returns a [Script] instance or [code]null[/code].
func get_typed_script() -> Variant:
	pass;

## Returns [code]true[/code] if the array contains the given value.
## [codeblocks]
## [gdscript]
## print(["inside", 7].has("inside")) # True
## print(["inside", 7].has("outside")) # False
## print(["inside", 7].has(7)) # True
## print(["inside", 7].has("7")) # False
## [/gdscript]
## [csharp]
## var arr = new Godot.Collections.Array { "inside", 7 };
## // has is renamed to Contains
## GD.Print(arr.Contains("inside")); // True
## GD.Print(arr.Contains("outside")); // False
## GD.Print(arr.Contains(7)); // True
## GD.Print(arr.Contains("7")); // False
## [/csharp]
## [/codeblocks]
## [b]Note:[/b] This is equivalent to using the [code]in[/code] operator as follows:
## [codeblocks]
## [gdscript]
## # Will evaluate to `true`.
## if 2 in [2, 4, 6, 8]:
## print("Contains!")
## [/gdscript]
## [csharp]
## // As there is no "in" keyword in C#, you have to use Contains
## var array = new Godot.Collections.Array { 2, 4, 6, 8 };
## if (array.Contains(2))
## {
## GD.Print("Contains!");
## }
## [/csharp]
## [/codeblocks]
func has(value: Variant) -> bool:
	pass;

## Returns a hashed 32-bit integer value representing the array and its contents.
## [b]Note:[/b] [Array]s with equal content will always produce identical hash values. However, the reverse is not true. Returning identical hash values does [i]not[/i] imply the arrays are equal, because different arrays can have identical hash values due to hash collisions.
func hash() -> int:
	pass;

## Inserts a new element at a given position in the array. The position must be valid, or at the end of the array ([code]pos == size()[/code]). Returns [constant OK] on success, or one of the other [enum Error] values if the operation failed.
## [b]Note:[/b] This method acts in-place and doesn't return a modified array.
## [b]Note:[/b] On large arrays, this method will be slower if the inserted element is close to the beginning of the array (index 0). This is because all elements placed after the newly inserted element have to be reindexed.
func insert(position: int, value: Variant) -> int:
	pass;

## Returns [code]true[/code] if the array is empty.
func is_empty() -> bool:
	pass;

## Returns [code]true[/code] if the array is read-only. See [method make_read_only]. Arrays are automatically read-only if declared with [code]const[/code] keyword.
func is_read_only() -> bool:
	pass;

## Returns [code]true[/code] if the array is typed the same as [param array].
func is_same_typed(array: Array) -> bool:
	pass;

## Returns [code]true[/code] if the array is typed. Typed arrays can only store elements of their associated type and provide type safety for the [code][][/code] operator. Methods of typed array still return [Variant].
func is_typed() -> bool:
	pass;

## Makes the array read-only, i.e. disabled modifying of the array's elements. Does not apply to nested content, e.g. content of nested arrays.
func make_read_only() -> void:
	pass;

## Calls the provided [Callable] for each element in the array and returns a new array filled with values returned by the method.
## The callable's method should take one [Variant] parameter (the current array element) and can return any [Variant].
## [codeblock]
## func _ready():
## print([1, 2, 3].map(negate)) # Prints [-1, -2, -3].
## print([1, 2, 3].map(func(number): return -number)) # Same as above, but using lambda function.
## func negate(number):
## return -number
## [/codeblock]
## See also [method filter], [method reduce], [method any] and [method all].
func map(method: Callable) -> Array:
	pass;

## Returns the maximum value contained in the array if all elements are of comparable types. If the elements can't be compared, [code]null[/code] is returned.
## To find the maximum value using a custom comparator, you can use [method reduce]. In this example every array element is checked and the first maximum value is returned:
## [codeblock]
## func _ready():
## var arr = [Vector2(0, 1), Vector2(2, 0), Vector2(1, 1), Vector2(1, 0), Vector2(0, 2)]
## # In this example we compare the lengths.
## print(arr.reduce(func(max, val): return val if is_length_greater(val, max) else max))
## func is_length_greater(a, b):
## return a.length() > b.length()
## [/codeblock]
func max() -> Variant:
	pass;

## Returns the minimum value contained in the array if all elements are of comparable types. If the elements can't be compared, [code]null[/code] is returned.
## See also [method max] for an example of using a custom comparator.
func min() -> Variant:
	pass;

## Returns a random value from the target array. Prints an error and returns [code]null[/code] if the array is empty.
## [codeblocks]
## [gdscript]
## var array: Array[int] = [1, 2, 3, 4]
## print(array.pick_random())  # Prints either of the four numbers.
## [/gdscript]
## [csharp]
## var array = new Godot.Collections.Array { 1, 2, 3, 4 };
## GD.Print(array.PickRandom()); // Prints either of the four numbers.
## [/csharp]
## [/codeblocks]
func pick_random() -> Variant:
	pass;

## Removes and returns the element of the array at index [param position]. If negative, [param position] is considered relative to the end of the array. Leaves the array unchanged and returns [code]null[/code] if the array is empty or if it's accessed out of bounds. An error message is printed when the array is accessed out of bounds, but not when the array is empty.
## [b]Note:[/b] On large arrays, this method can be slower than [method pop_back] as it will reindex the array's elements that are located after the removed element. The larger the array and the lower the index of the removed element, the slower [method pop_at] will be.
func pop_at(position: int) -> Variant:
	pass;

## Removes and returns the last element of the array. Returns [code]null[/code] if the array is empty, without printing an error message. See also [method pop_front].
func pop_back() -> Variant:
	pass;

## Removes and returns the first element of the array. Returns [code]null[/code] if the array is empty, without printing an error message. See also [method pop_back].
## [b]Note:[/b] On large arrays, this method is much slower than [method pop_back] as it will reindex all the array's elements every time it's called. The larger the array, the slower [method pop_front] will be.
func pop_front() -> Variant:
	pass;

## Appends an element at the end of the array. See also [method push_front].
func push_back(value: Variant) -> void:
	pass;

## Adds an element at the beginning of the array. See also [method push_back].
## [b]Note:[/b] On large arrays, this method is much slower than [method push_back] as it will reindex all the array's elements every time it's called. The larger the array, the slower [method push_front] will be.
func push_front(value: Variant) -> void:
	pass;

## Calls the provided [Callable] for each element in array and accumulates the result in [param accum].
## The callable's method takes two arguments: the current value of [param accum] and the current array element. If [param accum] is [code]null[/code] (default value), the iteration will start from the second element, with the first one used as initial value of [param accum].
## [codeblock]
## func _ready():
## print([1, 2, 3].reduce(sum, 10)) # Prints 16.
## print([1, 2, 3].reduce(func(accum, number): return accum + number, 10)) # Same as above, but using lambda function.
## func sum(accum, number):
## return accum + number
## [/codeblock]
## See also [method map], [method filter], [method any] and [method all].
func reduce(method: Callable, accum: Variant = null) -> Variant:
	pass;

## Removes an element from the array by index. If the index does not exist in the array, nothing happens. To remove an element by searching for its value, use [method erase] instead.
## [b]Note:[/b] This method acts in-place and doesn't return a modified array.
## [b]Note:[/b] On large arrays, this method will be slower if the removed element is close to the beginning of the array (index 0). This is because all elements placed after the removed element have to be reindexed.
## [b]Note:[/b] [param position] cannot be negative. To remove an element relative to the end of the array, use [code]arr.remove_at(arr.size() - (i + 1))[/code]. To remove the last element from the array without returning the value, use [code]arr.resize(arr.size() - 1)[/code].
func remove_at(position: int) -> void:
	pass;

## Resizes the array to contain a different number of elements. If the array size is smaller, elements are cleared, if bigger, new elements are [code]null[/code]. Returns [constant OK] on success, or one of the other [enum Error] values if the operation failed.
## Calling [method resize] once and assigning the new values is faster than adding new elements one by one.
## [b]Note:[/b] This method acts in-place and doesn't return a modified array.
func resize(size: int) -> int:
	pass;

## Reverses the order of the elements in the array.
func reverse() -> void:
	pass;

## Searches the array in reverse order. Optionally, a start search index can be passed. If negative, the start index is considered relative to the end of the array.
func rfind(what: Variant, from: int = -1) -> int:
	pass;

## Shuffles the array such that the items will have a random order. This method uses the global random number generator common to methods such as [method @GlobalScope.randi]. Call [method @GlobalScope.randomize] to ensure that a new seed will be used each time if you want non-reproducible shuffling.
func shuffle() -> void:
	pass;

## Returns the number of elements in the array.
func size() -> int:
	pass;

## Returns the slice of the [Array], from [param begin] (inclusive) to [param end] (exclusive), as a new [Array].
## The absolute value of [param begin] and [param end] will be clamped to the array size, so the default value for [param end] makes it slice to the size of the array by default (i.e. [code]arr.slice(1)[/code] is a shorthand for [code]arr.slice(1, arr.size())[/code]).
## If either [param begin] or [param end] are negative, they will be relative to the end of the array (i.e. [code]arr.slice(0, -2)[/code] is a shorthand for [code]arr.slice(0, arr.size() - 2)[/code]).
## If specified, [param step] is the relative index between source elements. It can be negative, then [param begin] must be higher than [param end]. For example, [code][0, 1, 2, 3, 4, 5].slice(5, 1, -2)[/code] returns [code][5, 3][/code].
## If [param deep] is true, each element will be copied by value rather than by reference.
## [b]Note:[/b] To include the first element when [param step] is negative, use [code]arr.slice(begin, -arr.size() - 1, step)[/code] (i.e. [code][0, 1, 2].slice(1, -4, -1)[/code] returns [code][1, 0][/code]).
func slice(begin: int, end: int = 2147483647, step: int = 1, deep: bool = false) -> Array:
	pass;

## Sorts the array.
## [b]Note:[/b] The sorting algorithm used is not [url=https://en.wikipedia.org/wiki/Sorting_algorithm#Stability]stable[/url]. This means that values considered equal may have their order changed when using [method sort].
## [b]Note:[/b] Strings are sorted in alphabetical order (as opposed to natural order). This may lead to unexpected behavior when sorting an array of strings ending with a sequence of numbers. Consider the following example:
## [codeblocks]
## [gdscript]
## var strings = ["string1", "string2", "string10", "string11"]
## strings.sort()
## print(strings) # Prints [string1, string10, string11, string2]
## [/gdscript]
## [csharp]
## var strings = new Godot.Collections.Array { "string1", "string2", "string10", "string11" };
## strings.Sort();
## GD.Print(strings); // Prints [string1, string10, string11, string2]
## [/csharp]
## [/codeblocks]
## To perform natural order sorting, you can use [method sort_custom] with [method String.naturalnocasecmp_to] as follows:
## [codeblock]
## var strings = ["string1", "string2", "string10", "string11"]
## strings.sort_custom(func(a, b): return a.naturalnocasecmp_to(b) < 0)
## print(strings) # Prints [string1, string2, string10, string11]
## [/codeblock]
func sort() -> void:
	pass;

## Sorts the array using a custom method. The custom method receives two arguments (a pair of elements from the array) and must return either [code]true[/code] or [code]false[/code]. For two elements [code]a[/code] and [code]b[/code], if the given method returns [code]true[/code], element [code]b[/code] will be after element [code]a[/code] in the array.
## [b]Note:[/b] The sorting algorithm used is not [url=https://en.wikipedia.org/wiki/Sorting_algorithm#Stability]stable[/url]. This means that values considered equal may have their order changed when using [method sort_custom].
## [b]Note:[/b] You cannot randomize the return value as the heapsort algorithm expects a deterministic result. Randomizing the return value will result in unexpected behavior.
## [codeblocks]
## [gdscript]
## func sort_ascending(a, b):
## if a[0] < b[0]:
## return true
## return false
## func _ready():
## var my_items = [[5, "Potato"], [9, "Rice"], [4, "Tomato"]]
## my_items.sort_custom(sort_ascending)
## print(my_items) # Prints [[4, Tomato], [5, Potato], [9, Rice]].
## # Descending, lambda version.
## my_items.sort_custom(func(a, b): return a[0] > b[0])
## print(my_items) # Prints [[9, Rice], [5, Potato], [4, Tomato]].
## [/gdscript]
## [csharp]
## // There is no custom sort support for Godot.Collections.Array
## [/csharp]
## [/codeblocks]
func sort_custom(func: Callable) -> void:
	pass;


