extends AnimationMixer
class_name AnimationTree

## A node used for advanced animation transitions in an [AnimationPlayer].
##
## A node used for advanced animation transitions in an [AnimationPlayer].
## [b]Note:[/b] When linked with an [AnimationPlayer], several properties and methods of the corresponding [AnimationPlayer] will not function as expected. Playback and transitions should be handled using only the [AnimationTree] and its constituent [AnimationNode](s). The [AnimationPlayer] node should be used solely for adding, deleting, and editing animations.
##
## @tutorial(Using AnimationTree): https://docs.godotengine.org/en/stable/tutorials/animation/animation_tree.html
## @tutorial(Third Person Shooter Demo): https://godotengine.org/asset-library/asset/678


## Emitted when the [member anim_player] is changed.
signal animation_player_changed
## For backward compatibility. See [constant AnimationMixer.ANIMATION_CALLBACK_MODE_PROCESS_PHYSICS].
## @deprecated
## For backward compatibility. See [constant AnimationMixer.ANIMATION_CALLBACK_MODE_PROCESS_IDLE].
## @deprecated
## For backward compatibility. See [constant AnimationMixer.ANIMATION_CALLBACK_MODE_PROCESS_MANUAL].
## @deprecated

#enum AnimationProcessCallback
enum {
    ANIMATION_PROCESS_PHYSICS = 0,
    ANIMATION_PROCESS_IDLE = 1,
    ANIMATION_PROCESS_MANUAL = 2,
}
## The path to the [Node] used to evaluate the [AnimationNode] [Expression] if one is not explicitly specified internally.
var advance_expression_base_node: NodePath:
	get = get_advance_expression_base_node, set = set_advance_expression_base_node

## The path to the [AnimationPlayer] used for animating.
var anim_player: NodePath:
	get = get_animation_player, set = set_animation_player

var deterministic: bool:
	get = is_deterministic, set = set_deterministic

## The root animation node of this [AnimationTree]. See [AnimationRootNode].
var tree_root: AnimationRootNode:
	get = get_tree_root, set = set_tree_root



## For backward compatibility. See [enum AnimationMixer.AnimationCallbackModeProcess].
## @deprecated
func get_process_callback() -> int:
	pass;

## For backward compatibility. See [enum AnimationMixer.AnimationCallbackModeProcess].
## @deprecated
func set_process_callback(mode: int) -> void:
	pass;


func get_advance_expression_base_node() -> NodePath:
	return advance_expression_base_node

func set_advance_expression_base_node(value: NodePath) -> void:
	advance_expression_base_node = value

func get_animation_player() -> NodePath:
	return anim_player

func set_animation_player(value: NodePath) -> void:
	anim_player = value

func is_deterministic() -> bool:
	return deterministic

func set_deterministic(value: bool) -> void:
	deterministic = value

func get_tree_root() -> AnimationRootNode:
	return tree_root

func set_tree_root(value: AnimationRootNode) -> void:
	tree_root = value

