extends RefCounted
class_name ZIPReader

## Allows reading the content of a zip file.
##
## This class implements a reader that can extract the content of individual files inside a zip archive.
## [codeblock]
## func read_zip_file():
## var reader := ZIPReader.new()
## var err := reader.open("user://archive.zip")
## if err != OK:
## return PackedByteArray()
## var res := reader.read_file("hello.txt")
## reader.close()
## return res
## [/codeblock]





## Closes the underlying resources used by this instance.
func close() -> int:
	pass;

## Returns [code]true[/code] if the file exists in the loaded zip archive.
## Must be called after [method open].
func file_exists(path: String, case_sensitive: bool = true) -> bool:
	pass;

## Returns the list of names of all files in the loaded archive.
## Must be called after [method open].
func get_files() -> PackedStringArray:
	pass;

## Opens the zip archive at the given [param path] and reads its file index.
func open(path: String) -> int:
	pass;

## Loads the whole content of a file in the loaded zip archive into memory and returns it.
## Must be called after [method open].
func read_file(path: String, case_sensitive: bool = true) -> PackedByteArray:
	pass;


