extends Resource
class_name X509Certificate

## An X509 certificate (e.g. for TLS).
##
## The X509Certificate class represents an X509 certificate. Certificates can be loaded and saved like any other [Resource].
## They can be used as the server certificate in [method StreamPeerTLS.accept_stream] (along with the proper [CryptoKey]), and to specify the only certificate that should be accepted when connecting to a TLS server via [method StreamPeerTLS.connect_to_stream].
##
## @tutorial(SSL certificates): https://docs.godotengine.org/en/stable/tutorials/networking/ssl_certificates.html





## Loads a certificate from [param path] ("*.crt" file).
func load(path: String) -> int:
	pass;

## Loads a certificate from the given [param string].
func load_from_string(string: String) -> int:
	pass;

## Saves a certificate to the given [param path] (should be a "*.crt" file).
func save(path: String) -> int:
	pass;

## Returns a string representation of the certificate, or an empty string if the certificate is invalid.
func save_to_string() -> String:
	pass;


