extends VisualShaderNodeResizableBase
class_name VisualShaderNodeGroupBase

## Base class for a family of nodes with variable number of input and output ports within the visual shader graph.
##
## Currently, has no direct usage, use the derived classes instead.





## Adds an input port with the specified [param type] (see [enum VisualShaderNode.PortType]) and [param name].
func add_input_port(id: int, type: int, name: String) -> void:
	pass;

## Adds an output port with the specified [param type] (see [enum VisualShaderNode.PortType]) and [param name].
func add_output_port(id: int, type: int, name: String) -> void:
	pass;

## Removes all previously specified input ports.
func clear_input_ports() -> void:
	pass;

## Removes all previously specified output ports.
func clear_output_ports() -> void:
	pass;

## Returns a free input port ID which can be used in [method add_input_port].
func get_free_input_port_id() -> int:
	pass;

## Returns a free output port ID which can be used in [method add_output_port].
func get_free_output_port_id() -> int:
	pass;

## Returns the number of input ports in use. Alternative for [method get_free_input_port_id].
func get_input_port_count() -> int:
	pass;

## Returns a [String] description of the input ports as a colon-separated list using the format [code]id,type,name;[/code] (see [method add_input_port]).
func get_inputs() -> String:
	pass;

## Returns the number of output ports in use. Alternative for [method get_free_output_port_id].
func get_output_port_count() -> int:
	pass;

## Returns a [String] description of the output ports as a colon-separated list using the format [code]id,type,name;[/code] (see [method add_output_port]).
func get_outputs() -> String:
	pass;

## Returns [code]true[/code] if the specified input port exists.
func has_input_port(id: int) -> bool:
	pass;

## Returns [code]true[/code] if the specified output port exists.
func has_output_port(id: int) -> bool:
	pass;

## Returns [code]true[/code] if the specified port name does not override an existed port name and is valid within the shader.
func is_valid_port_name(name: String) -> bool:
	pass;

## Removes the specified input port.
func remove_input_port(id: int) -> void:
	pass;

## Removes the specified output port.
func remove_output_port(id: int) -> void:
	pass;

## Renames the specified input port.
func set_input_port_name(id: int, name: String) -> void:
	pass;

## Sets the specified input port's type (see [enum VisualShaderNode.PortType]).
func set_input_port_type(id: int, type: int) -> void:
	pass;

## Defines all input ports using a [String] formatted as a colon-separated list: [code]id,type,name;[/code] (see [method add_input_port]).
func set_inputs(inputs: String) -> void:
	pass;

## Renames the specified output port.
func set_output_port_name(id: int, name: String) -> void:
	pass;

## Sets the specified output port's type (see [enum VisualShaderNode.PortType]).
func set_output_port_type(id: int, type: int) -> void:
	pass;

## Defines all output ports using a [String] formatted as a colon-separated list: [code]id,type,name;[/code] (see [method add_output_port]).
func set_outputs(outputs: String) -> void:
	pass;


