extends StreamPeer
class_name StreamPeerBuffer

## A stream peer used to handle binary data streams.
##
## A data buffer stream peer that uses a byte array as the stream. This object can be used to handle binary data from network sessions. To handle binary data stored in files, [FileAccess] can be used directly.
## A [StreamPeerBuffer] object keeps an internal cursor which is the offset in bytes to the start of the buffer. Get and put operations are performed at the cursor position and will move the cursor accordingly.



## The underlying data buffer. Setting this value resets the cursor.
var data_array: PackedByteArray:
	get = get_data_array, set = set_data_array



## Clears the [member data_array] and resets the cursor.
func clear() -> void:
	pass;

## Returns a new [StreamPeerBuffer] with the same [member data_array] content.
func duplicate() -> StreamPeerBuffer:
	pass;

## Returns the current cursor position.
func get_position() -> int:
	pass;

## Returns the size of [member data_array].
func get_size() -> int:
	pass;

## Resizes the [member data_array]. This [i]doesn't[/i] update the cursor.
func resize(size: int) -> void:
	pass;

## Moves the cursor to the specified position. [param position] must be a valid index of [member data_array].
func seek(position: int) -> void:
	pass;


func get_data_array() -> PackedByteArray:
	return data_array

func set_data_array(value: PackedByteArray) -> void:
	data_array = value

