extends Resource
class_name Shortcut

## A shortcut for binding input.
##
## Shortcuts are commonly used for interacting with a [Control] element from an [InputEvent] (also known as hotkeys).
## One shortcut can contain multiple [InputEvent]'s, allowing the possibility of triggering one action with multiple different inputs.



## The shortcut's [InputEvent] array.
## Generally the [InputEvent] used is an [InputEventKey], though it can be any [InputEvent], including an [InputEventAction].
var events: Array:
	get = get_events, set = set_events



## Returns the shortcut's first valid [InputEvent] as a [String].
func get_as_text() -> String:
	pass;

## Returns whether [member events] contains an [InputEvent] which is valid.
func has_valid_event() -> bool:
	pass;

## Returns whether any [InputEvent] in [member events] equals [param event].
func matches_event(event: InputEvent) -> bool:
	pass;


func get_events() -> Array:
	return events

func set_events(value: Array) -> void:
	events = value

