extends PanelContainer
class_name ScriptEditor

## Godot editor's script editor.
##
## Godot editor's script editor.
## [b]Note:[/b] This class shouldn't be instantiated directly. Instead, access the singleton using [method EditorInterface.get_script_editor].


## Emitted when user changed active script. Argument is a freshly activated [Script].
signal editor_script_changed(script: Script)
## Emitted when editor is about to close the active script. Argument is a [Script] that is going to be closed.
signal script_close(script: Script)



## Returns the [ScriptEditorBase] object that the user is currently editing.
func get_current_editor() -> ScriptEditorBase:
	pass;

## Returns a [Script] that is currently active in editor.
func get_current_script() -> Script:
	pass;

## Returns an array with all [ScriptEditorBase] objects which are currently open in editor.
func get_open_script_editors() -> Array[ScriptEditorBase]:
	pass;

## Returns an array with all [Script] objects which are currently open in editor.
func get_open_scripts() -> Array[Script]:
	pass;

## Goes to the specified line in the current script.
func goto_line(line_number: int) -> void:
	pass;

## Opens the script create dialog. The script will extend [param base_name]. The file extension can be omitted from [param base_path]. It will be added based on the selected scripting language.
func open_script_create_dialog(base_name: String, base_path: String) -> void:
	pass;

## Registers the [EditorSyntaxHighlighter] to the editor, the [EditorSyntaxHighlighter] will be available on all open scripts.
## [b]Note:[/b] Does not apply to scripts that are already opened.
func register_syntax_highlighter(syntax_highlighter: EditorSyntaxHighlighter) -> void:
	pass;

## Unregisters the [EditorSyntaxHighlighter] from the editor.
## [b]Note:[/b] The [EditorSyntaxHighlighter] will still be applied to scripts that are already opened.
func unregister_syntax_highlighter(syntax_highlighter: EditorSyntaxHighlighter) -> void:
	pass;


