extends Material
class_name ProceduralSkyMaterial

## A material that defines a simple sky for a [Sky] resource.
##
## [ProceduralSkyMaterial] provides a way to create an effective background quickly by defining procedural parameters for the sun, the sky and the ground. The sky and ground are defined by a main color, a color at the horizon, and an easing curve to interpolate between them. Suns are described by a position in the sky, a color, and a max angle from the sun at which the easing curve ends. The max angle therefore defines the size of the sun in the sky.
## [ProceduralSkyMaterial] supports up to 4 suns, using the color, and energy, direction, and angular distance of the first four [DirectionalLight3D] nodes in the scene. This means that the suns are defined individually by the properties of their corresponding [DirectionalLight3D]s and globally by [member sun_angle_max] and [member sun_curve].
## [ProceduralSkyMaterial] uses a lightweight shader to draw the sky and is therefore suited for real time updates. This makes it a great option for a sky that is simple and computationally cheap, but unrealistic. If you need a more realistic procedural option, use [PhysicalSkyMaterial].



## Color of the ground at the bottom. Blends with [member ground_horizon_color].
var ground_bottom_color: Color:
	get = get_ground_bottom_color, set = set_ground_bottom_color

## How quickly the [member ground_horizon_color] fades into the [member ground_bottom_color].
var ground_curve: float:
	get = get_ground_curve, set = set_ground_curve

## Multiplier for ground color. A higher value will make the ground brighter.
var ground_energy_multiplier: float:
	get = get_ground_energy_multiplier, set = set_ground_energy_multiplier

## Color of the ground at the horizon. Blends with [member ground_bottom_color].
var ground_horizon_color: Color:
	get = get_ground_horizon_color, set = set_ground_horizon_color

## The sky cover texture to use. This texture must use an equirectangular projection (similar to [PanoramaSkyMaterial]). The texture's colors will be [i]added[/i] to the existing sky color, and will be multiplied by [member sky_energy_multiplier] and [member sky_cover_modulate]. This is mainly suited to displaying stars at night, but it can also be used to display clouds at day or night (with a non-physically-accurate look).
var sky_cover: Texture2D:
	get = get_sky_cover, set = set_sky_cover

## The tint to apply to the [member sky_cover] texture. This can be used to change the sky cover's colors or opacity independently of the sky energy, which is useful for day/night or weather transitions. Only effective if a texture is defined in [member sky_cover].
var sky_cover_modulate: Color:
	get = get_sky_cover_modulate, set = set_sky_cover_modulate

## How quickly the [member sky_horizon_color] fades into the [member sky_top_color].
var sky_curve: float:
	get = get_sky_curve, set = set_sky_curve

## Multiplier for sky color. A higher value will make the sky brighter.
var sky_energy_multiplier: float:
	get = get_sky_energy_multiplier, set = set_sky_energy_multiplier

## Color of the sky at the horizon. Blends with [member sky_top_color].
var sky_horizon_color: Color:
	get = get_sky_horizon_color, set = set_sky_horizon_color

## Color of the sky at the top. Blends with [member sky_horizon_color].
var sky_top_color: Color:
	get = get_sky_top_color, set = set_sky_top_color

## Distance from center of sun where it fades out completely.
var sun_angle_max: float:
	get = get_sun_angle_max, set = set_sun_angle_max

## How quickly the sun fades away between the edge of the sun disk and [member sun_angle_max].
var sun_curve: float:
	get = get_sun_curve, set = set_sun_curve

## If [code]true[/code], enables debanding. Debanding adds a small amount of noise which helps reduce banding that appears from the smooth changes in color in the sky.
var use_debanding: bool:
	get = get_use_debanding, set = set_use_debanding




func get_ground_bottom_color() -> Color:
	return ground_bottom_color

func set_ground_bottom_color(value: Color) -> void:
	ground_bottom_color = value

func get_ground_curve() -> float:
	return ground_curve

func set_ground_curve(value: float) -> void:
	ground_curve = value

func get_ground_energy_multiplier() -> float:
	return ground_energy_multiplier

func set_ground_energy_multiplier(value: float) -> void:
	ground_energy_multiplier = value

func get_ground_horizon_color() -> Color:
	return ground_horizon_color

func set_ground_horizon_color(value: Color) -> void:
	ground_horizon_color = value

func get_sky_cover() -> Texture2D:
	return sky_cover

func set_sky_cover(value: Texture2D) -> void:
	sky_cover = value

func get_sky_cover_modulate() -> Color:
	return sky_cover_modulate

func set_sky_cover_modulate(value: Color) -> void:
	sky_cover_modulate = value

func get_sky_curve() -> float:
	return sky_curve

func set_sky_curve(value: float) -> void:
	sky_curve = value

func get_sky_energy_multiplier() -> float:
	return sky_energy_multiplier

func set_sky_energy_multiplier(value: float) -> void:
	sky_energy_multiplier = value

func get_sky_horizon_color() -> Color:
	return sky_horizon_color

func set_sky_horizon_color(value: Color) -> void:
	sky_horizon_color = value

func get_sky_top_color() -> Color:
	return sky_top_color

func set_sky_top_color(value: Color) -> void:
	sky_top_color = value

func get_sun_angle_max() -> float:
	return sun_angle_max

func set_sun_angle_max(value: float) -> void:
	sun_angle_max = value

func get_sun_curve() -> float:
	return sun_curve

func set_sun_curve(value: float) -> void:
	sun_curve = value

func get_use_debanding() -> bool:
	return use_debanding

func set_use_debanding(value: bool) -> void:
	use_debanding = value

