extends Object
class_name OpenXRExtensionWrapperExtension

## Allows clients to implement OpenXR extensions with GDExtension.
##
## [OpenXRExtensionWrapperExtension] allows clients to implement OpenXR extensions with GDExtension. The extension should be registered with [method register_extension_wrapper].





## Returns a [Dictionary] of OpenXR extensions related to this extension. The [Dictionary] should contain the name of the extension, mapped to a [code]bool *[/code] cast to an integer:
## - If the [code]bool *[/code] is a [code]nullptr[/code] this extension is mandatory.
## - If the [code]bool *[/code] points to a boolean, the boolean will be updated to [code]true[/code] if the extension is enabled.
func _get_requested_extensions() -> Dictionary:
	pass;

## Called before the OpenXR instance is created.
func _on_before_instance_created() -> void:
	pass;

## Called when there is an OpenXR event to process. When implementing, return [code]true[/code] if the event was handled, return [code]false[/code] otherwise.
func _on_event_polled(event: const void*) -> bool:
	pass;

## Called right after the OpenXR instance is created.
func _on_instance_created(instance: int) -> void:
	pass;

## Called right before the OpenXR instance is destroyed.
func _on_instance_destroyed() -> void:
	pass;

## Called right before the XR viewports begin their rendering step.
func _on_pre_render() -> void:
	pass;

## Called as part of the OpenXR process handling. This happens right before general and physics processing steps of the main loop. During this step controller data is queried and made available to game logic.
func _on_process() -> void:
	pass;

## Allows extensions to register additional controller metadata. This function is called even when the OpenXR API is not constructed as the metadata needs to be available to the editor.
## Extensions should also provide metadata regardless of whether they are supported on the host system. The controller data is used to setup action maps for users who may have access to the relevant hardware.
func _on_register_metadata() -> void:
	pass;

## Called right after the OpenXR session is created.
func _on_session_created(session: int) -> void:
	pass;

## Called right before the OpenXR session is destroyed.
func _on_session_destroyed() -> void:
	pass;

## Called when the OpenXR session state is changed to exiting.
func _on_state_exiting() -> void:
	pass;

## Called when the OpenXR session state is changed to focused. This state is the active state when the game runs.
func _on_state_focused() -> void:
	pass;

## Called when the OpenXR session state is changed to idle.
func _on_state_idle() -> void:
	pass;

## Called when the OpenXR session state is changed to loss pending.
func _on_state_loss_pending() -> void:
	pass;

## Called when the OpenXR session state is changed to ready. This means OpenXR is ready to set up the session.
func _on_state_ready() -> void:
	pass;

## Called when the OpenXR session state is changed to stopping.
func _on_state_stopping() -> void:
	pass;

## Called when the OpenXR session state is changed to synchronized. OpenXR also returns to this state when the application loses focus.
func _on_state_synchronized() -> void:
	pass;

## Called when the OpenXR session state is changed to visible. This means OpenXR is now ready to receive frames.
func _on_state_visible() -> void:
	pass;

## Adds additional data structures when the OpenXR instance is created.
func _set_instance_create_info_and_get_next_pointer(next_pointer: void*) -> int:
	pass;

## Adds additional data structures when the OpenXR session is created.
func _set_session_create_and_get_next_pointer(next_pointer: void*) -> int:
	pass;

## Adds additional data structures when creating OpenXR swapchains.
func _set_swapchain_create_info_and_get_next_pointer(next_pointer: void*) -> int:
	pass;

## Adds additional data structures when interogating OpenXR system abilities.
func _set_system_properties_and_get_next_pointer(next_pointer: void*) -> int:
	pass;

## Returns the created [OpenXRAPIExtension], which can be used to access the OpenXR API.
func get_openxr_api() -> OpenXRAPIExtension:
	pass;

## Registers the extension. This should happen at core module initialization level.
func register_extension_wrapper() -> void:
	pass;


