extends RefCounted
class_name OpenXRAPIExtension

## Makes the OpenXR API available for GDExtension.
##
## [OpenXRAPIExtension] makes OpenXR available for GDExtension. It provides the OpenXR API to GDExtension through the [method get_instance_proc_addr] method, and the OpenXR instance through [method get_instance].
## It also provides methods for querying the status of OpenXR initialization, and helper methods for ease of use of the API with GDExtension.
##
## @tutorial(XrResult documentation): https://registry.khronos.org/OpenXR/specs/1.0/man/html/XrResult.html
## @tutorial(XrInstance documentation): https://registry.khronos.org/OpenXR/specs/1.0/man/html/XrInstance.html
## @tutorial(XrSpace documentation): https://registry.khronos.org/OpenXR/specs/1.0/man/html/XrSpace.html
## @tutorial(XrSession documentation): https://registry.khronos.org/OpenXR/specs/1.0/man/html/XrSession.html
## @tutorial(XrSystemId documentation): https://registry.khronos.org/OpenXR/specs/1.0/man/html/XrSystemId.html
## @tutorial(xrBeginSession documentation): https://registry.khronos.org/OpenXR/specs/1.0/man/html/xrBeginSession.html
## @tutorial(XrPosef documentation): https://registry.khronos.org/OpenXR/specs/1.0/man/html/XrPosef.html





## Returns [code]true[/code] if OpenXR is initialized for rendering with an XR viewport.
func can_render() -> bool:
	pass;

## Returns an error string for the given [url=https://registry.khronos.org/OpenXR/specs/1.0/man/html/XrResult.html]XrResult[/url].
func get_error_string(result: int) -> String:
	pass;

## Returns the [url=https://registry.khronos.org/OpenXR/specs/1.0/man/html/XrInstance.html]XrInstance[/url] created during the initialization of the OpenXR API.
func get_instance() -> int:
	pass;

## Returns the function pointer of the OpenXR function with the specified name, cast to an integer. If the function with the given name does not exist, the method returns [code]0[/code].
## [b]Note:[/b] [code]openxr/util.h[/code] contains utility macros for acquiring OpenXR functions, e.g. [code]GDEXTENSION_INIT_XR_FUNC_V(xrCreateAction)[/code].
func get_instance_proc_addr(name: String) -> int:
	pass;

## Returns the timing for the next frame.
func get_next_frame_time() -> int:
	pass;

## Returns the play space, which is an [url=https://registry.khronos.org/OpenXR/specs/1.0/man/html/XrSpace.html]XrSpace[/url] cast to an integer.
func get_play_space() -> int:
	pass;

## Returns the OpenXR session, which is an [url=https://registry.khronos.org/OpenXR/specs/1.0/man/html/XrSession.html]XrSession[/url] cast to an integer.
func get_session() -> int:
	pass;

## Returns the name of the specified swapchain format.
func get_swapchain_format_name(swapchain_format: int) -> String:
	pass;

## Returns the id of the system, which is a [url=https://registry.khronos.org/OpenXR/specs/1.0/man/html/XrSystemId.html]XrSystemId[/url] cast to an integer.
func get_system_id() -> int:
	pass;

## Returns [code]true[/code] if OpenXR is initialized.
func is_initialized() -> bool:
	pass;

## Returns [code]true[/code] if OpenXR is running ([url=https://registry.khronos.org/OpenXR/specs/1.0/man/html/xrBeginSession.html]xrBeginSession[/url] was successfully called and the swapchains were created).
func is_running() -> bool:
	pass;

## Returns [code]true[/code] if OpenXR is enabled.
static func openxr_is_enabled(check_run_in_editor: bool) -> bool:
	pass;

## Creates a [Transform3D] from an [url=https://registry.khronos.org/OpenXR/specs/1.0/man/html/XrPosef.html]XrPosef[/url].
func transform_from_pose(pose: const void*) -> Transform3D:
	pass;

## Returns [code]true[/code] if the provided [url=https://registry.khronos.org/OpenXR/specs/1.0/man/html/XrResult.html]XrResult[/url] (cast to an integer) is successful. Otherwise returns [code]false[/code] and prints the [url=https://registry.khronos.org/OpenXR/specs/1.0/man/html/XrResult.html]XrResult[/url] converted to a string, with the specified additional information.
func xr_result(result: int, format: String, args: Array) -> bool:
	pass;


