extends InputEventGesture
class_name InputEventMagnifyGesture

## Represents a magnifying touch gesture.
##
## Stores the factor of a magnifying touch gesture. This is usually performed when the user pinches the touch screen and used for zooming in/out.
## [b]Note:[/b] On Android, this requires the [member ProjectSettings.input_devices/pointing/android/enable_pan_and_scale_gestures] project setting to be enabled.
##
## @tutorial(Using InputEvent): https://docs.godotengine.org/en/stable/tutorials/inputs/inputevent.html



## The amount (or delta) of the event. This value is closer to [code]1.0[/code] the slower the gesture is performed.
var factor: float:
	get = get_factor, set = set_factor




func get_factor() -> float:
	return factor

func set_factor(value: float) -> void:
	factor = value

