extends GPUParticlesAttractor3D
class_name GPUParticlesAttractorBox3D

## A box-shaped attractor that influences particles from [GPUParticles3D] nodes.
##
## A box-shaped attractor that influences particles from [GPUParticles3D] nodes. Can be used to attract particles towards its origin, or to push them away from its origin.
## Particle attractors work in real-time and can be moved, rotated and scaled during gameplay. Unlike collision shapes, non-uniform scaling of attractors is also supported.
## [b]Note:[/b] Particle attractors only affect [GPUParticles3D], not [CPUParticles3D].



## The attractor box's size in 3D units.
var size: Vector3:
	get = get_size, set = set_size




func get_size() -> Vector3:
	return size

func set_size(value: Vector3) -> void:
	size = value

