extends Container
class_name AspectRatioContainer

## A container that preserves the proportions of its child controls.
##
## A container type that arranges its child controls in a way that preserves their proportions automatically when the container is resized. Useful when a container has a dynamic size and the child nodes must adjust their sizes accordingly without losing their aspect ratios.
##
## @tutorial(Using Containers): https://docs.godotengine.org/en/stable/tutorials/ui/gui_containers.html


## The height of child controls is automatically adjusted based on the width of the container.
## The width of child controls is automatically adjusted based on the height of the container.
## The bounding rectangle of child controls is automatically adjusted to fit inside the container while keeping the aspect ratio.
## The width and height of child controls is automatically adjusted to make their bounding rectangle cover the entire area of the container while keeping the aspect ratio.
## When the bounding rectangle of child controls exceed the container's size and [member Control.clip_contents] is enabled, this allows to show only the container's area restricted by its own bounding rectangle.
## Aligns child controls with the beginning (left or top) of the container.
## Aligns child controls with the center of the container.
## Aligns child controls with the end (right or bottom) of the container.

#enum StretchMode
enum {
    STRETCH_WIDTH_CONTROLS_HEIGHT = 0,
    STRETCH_HEIGHT_CONTROLS_WIDTH = 1,
    STRETCH_FIT = 2,
    STRETCH_COVER = 3,
}
#enum AlignmentMode
enum {
    ALIGNMENT_BEGIN = 0,
    ALIGNMENT_CENTER = 1,
    ALIGNMENT_END = 2,
}
## Specifies the horizontal relative position of child controls.
var alignment_horizontal: int:
	get = get_alignment_horizontal, set = set_alignment_horizontal

## Specifies the vertical relative position of child controls.
var alignment_vertical: int:
	get = get_alignment_vertical, set = set_alignment_vertical

## The aspect ratio to enforce on child controls. This is the width divided by the height. The ratio depends on the [member stretch_mode].
var ratio: float:
	get = get_ratio, set = set_ratio

## The stretch mode used to align child controls.
var stretch_mode: int:
	get = get_stretch_mode, set = set_stretch_mode




func get_alignment_horizontal() -> int:
	return alignment_horizontal

func set_alignment_horizontal(value: int) -> void:
	alignment_horizontal = value

func get_alignment_vertical() -> int:
	return alignment_vertical

func set_alignment_vertical(value: int) -> void:
	alignment_vertical = value

func get_ratio() -> float:
	return ratio

func set_ratio(value: float) -> void:
	ratio = value

func get_stretch_mode() -> int:
	return stretch_mode

func set_stretch_mode(value: int) -> void:
	stretch_mode = value

