extends AnimationNodeSync
class_name AnimationNodeSub2

## Blends two animations subtractively inside of an [AnimationNodeBlendTree].
##
## A resource to add to an [AnimationNodeBlendTree]. Blends two animations subtractively based on the amount value.
## This animation node is usually used for pre-calculation to cancel out any extra poses from the animation for the "add" animation source in [AnimationNodeAdd2] or [AnimationNodeAdd3].
## In general, the blend value should be in the [code][0.0, 1.0][/code] range, but values outside of this range can be used for amplified or inverted animations.
## [b]Note:[/b] This calculation is different from using a negative value in [AnimationNodeAdd2], since the transformation matrices do not satisfy the commutative law. [AnimationNodeSub2] multiplies the transformation matrix of the inverted animation from the left side, while negative [AnimationNodeAdd2] multiplies it from the right side.
##
## @tutorial(AnimationTree): https://docs.godotengine.org/en/stable/tutorials/animation/animation_tree.html






