extends StaticBody3D
class_name AnimatableBody3D

## A 3D physics body that can't be moved by external forces. When moved manually, it affects other bodies in its path.
##
## An animatable 3D physics body. It can't be moved by external forces or contacts, but can be moved manually by other means such as code, [AnimationMixer]s (with [member AnimationMixer.callback_mode_process] set to [constant AnimationMixer.ANIMATION_CALLBACK_MODE_PROCESS_PHYSICS]), and [RemoteTransform3D].
## When [AnimatableBody3D] is moved, its linear and angular velocity are estimated and used to affect other physics bodies in its path. This makes it useful for moving platforms, doors, and other moving objects.
##
## @tutorial(3D Physics Tests Demo): https://godotengine.org/asset-library/asset/675
## @tutorial(Third Person Shooter Demo): https://godotengine.org/asset-library/asset/678
## @tutorial(3D Voxel Demo): https://godotengine.org/asset-library/asset/676



## If [code]true[/code], the body's movement will be synchronized to the physics frame. This is useful when animating movement via [AnimationPlayer], for example on moving platforms. Do [b]not[/b] use together with [method PhysicsBody3D.move_and_collide].
var sync_to_physics: bool:
	get = is_sync_to_physics_enabled, set = set_sync_to_physics




func is_sync_to_physics_enabled() -> bool:
	return sync_to_physics

func set_sync_to_physics(value: bool) -> void:
	sync_to_physics = value

