extends VisualInstance3D
class_name VisibleOnScreenNotifier3D

## Detects approximately when the node is visible on screen.
##
## The VisibleOnScreenNotifier3D detects when it is visible on the screen. It also notifies when its bounding rectangle enters or exits the screen or a [Camera3D]'s view.
## If you want nodes to be disabled automatically when they exit the screen, use [VisibleOnScreenEnabler3D] instead.
## [b]Note:[/b] VisibleOnScreenNotifier3D uses the render culling code to determine whether it's visible on screen, which also means that its [member Node3D.visible] must be [code]true[/code] to work correctly.


## Emitted when the VisibleOnScreenNotifier3D enters the screen.
signal screen_entered
## Emitted when the VisibleOnScreenNotifier3D exits the screen.
signal screen_exited

## The VisibleOnScreenNotifier3D's bounding box.
var aabb: AABB:
	get = get_aabb, set = set_aabb



## If [code]true[/code], the bounding box is on the screen.
## [b]Note:[/b] It takes one frame for the node's visibility to be assessed once added to the scene tree, so this method will return [code]false[/code] right after it is instantiated, even if it will be on screen in the draw pass.
func is_on_screen() -> bool:
	pass;


func get_aabb() -> AABB:
	return aabb

func set_aabb(value: AABB) -> void:
	aabb = value

