extends Shape3D
class_name SphereShape3D

## A 3D sphere shape used for physics collision.
##
## A 3D sphere shape, intended for use in physics. Usually used to provide a shape for a [CollisionShape3D].
## [b]Performance:[/b] [SphereShape3D] is fast to check collisions against. It is faster than [BoxShape3D], [CapsuleShape3D], and [CylinderShape3D].
##
## @tutorial(3D Physics Tests Demo): https://godotengine.org/asset-library/asset/675



## The sphere's radius. The shape's diameter is double the radius.
var radius: float:
	get = get_radius, set = set_radius




func get_radius() -> float:
	return radius

func set_radius(value: float) -> void:
	radius = value

