extends Joint2D
class_name PinJoint2D

## A physics joint that attaches two 2D physics bodies at a single point, allowing them to freely rotate.
##
## A physics joint that attaches two 2D physics bodies at a single point, allowing them to freely rotate. For example, a [RigidBody2D] can be attached to a [StaticBody2D] to create a pendulum or a seesaw.



## The higher this value, the more the bond to the pinned partner can flex.
var softness: float:
	get = get_softness, set = set_softness




func get_softness() -> float:
	return softness

func set_softness(value: float) -> void:
	softness = value

