extends Node3D
class_name NavigationObstacle3D

## 3D Obstacle used in navigation to constrain avoidance controlled agents outside or inside an area.
##
## 3D Obstacle used in navigation to constrain avoidance controlled agents outside or inside an area. The obstacle needs a navigation map and outline vertices defined to work correctly.
## If the obstacle's vertices are winded in clockwise order, avoidance agents will be pushed in by the obstacle, otherwise, avoidance agents will be pushed out. Outlines must not cross or overlap.
## Obstacles are [b]not[/b] a replacement for a (re)baked navigation mesh. Obstacles [b]don't[/b] change the resulting path from the pathfinding, obstacles only affect the navigation avoidance agent movement by altering the suggested velocity of the avoidance agent.
## Obstacles using vertices can warp to a new position but should not moved every frame as each move requires a rebuild of the avoidance map.
##
## @tutorial(Using NavigationObstacles): https://docs.godotengine.org/en/stable/tutorials/navigation/navigation_using_navigationobstacles.html
## @experimental



## If [code]true[/code] the obstacle affects avoidance using agents.
var avoidance_enabled: bool:
	get = get_avoidance_enabled, set = set_avoidance_enabled

## A bitfield determining the avoidance layers for this obstacle. Agent's with a matching bit on the their avoidance mask will avoid this obstacle.
var avoidance_layers: int:
	get = get_avoidance_layers, set = set_avoidance_layers

## Sets the obstacle height used in 2D avoidance. 2D avoidance using agent's ignore obstacles that are below or above them.
var height: float:
	get = get_height, set = set_height

## Sets the avoidance radius for the obstacle.
var radius: float:
	get = get_radius, set = set_radius

## If [code]true[/code] the obstacle affects 3D avoidance using agent's with obstacle [member radius].
## If [code]false[/code] the obstacle affects 2D avoidance using agent's with both obstacle [member vertices] as well as obstacle [member radius].
var use_3d_avoidance: bool:
	get = get_use_3d_avoidance, set = set_use_3d_avoidance

## Sets the wanted velocity for the obstacle so other agent's can better predict the obstacle if it is moved with a velocity regularly (every frame) instead of warped to a new position. Does only affect avoidance for the obstacles [member radius]. Does nothing for the obstacles static vertices.
var velocity: Vector3:
	get = get_velocity, set = set_velocity

## The outline vertices of the obstacle. If the vertices are winded in clockwise order agents will be pushed in by the obstacle, else they will be pushed out. Outlines can not be crossed or overlap. Should the vertices using obstacle be warped to a new position agent's can not predict this movement and may get trapped inside the obstacle.
var vertices: PackedVector3Array:
	get = get_vertices, set = set_vertices



## Returns whether or not the specified layer of the [member avoidance_layers] bitmask is enabled, given a [param layer_number] between 1 and 32.
func get_avoidance_layer_value(layer_number: int) -> bool:
	pass;

## Returns the [RID] of the navigation map for this NavigationObstacle node. This function returns always the map set on the NavigationObstacle node and not the map of the abstract obstacle on the NavigationServer. If the obstacle map is changed directly with the NavigationServer API the NavigationObstacle node will not be aware of the map change. Use [method set_navigation_map] to change the navigation map for the NavigationObstacle and also update the obstacle on the NavigationServer.
func get_navigation_map() -> RID:
	pass;

## Returns the [RID] of this obstacle on the [NavigationServer3D].
func get_rid() -> RID:
	pass;

## Based on [param value], enables or disables the specified layer in the [member avoidance_layers] bitmask, given a [param layer_number] between 1 and 32.
func set_avoidance_layer_value(layer_number: int, value: bool) -> void:
	pass;

## Sets the [RID] of the navigation map this NavigationObstacle node should use and also updates the [code]obstacle[/code] on the NavigationServer.
func set_navigation_map(navigation_map: RID) -> void:
	pass;


func get_avoidance_enabled() -> bool:
	return avoidance_enabled

func set_avoidance_enabled(value: bool) -> void:
	avoidance_enabled = value

func get_avoidance_layers() -> int:
	return avoidance_layers

func set_avoidance_layers(value: int) -> void:
	avoidance_layers = value

func get_height() -> float:
	return height

func set_height(value: float) -> void:
	height = value

func get_radius() -> float:
	return radius

func set_radius(value: float) -> void:
	radius = value

func get_use_3d_avoidance() -> bool:
	return use_3d_avoidance

func set_use_3d_avoidance(value: bool) -> void:
	use_3d_avoidance = value

func get_velocity() -> Vector3:
	return velocity

func set_velocity(value: Vector3) -> void:
	velocity = value

func get_vertices() -> PackedVector3Array:
	return vertices

func set_vertices(value: PackedVector3Array) -> void:
	vertices = value

