extends Shape3D
class_name CylinderShape3D

## A 3D cylinder shape used for physics collision.
##
## A 2D capsule shape, intended for use in physics. Usually used to provide a shape for a [CollisionShape3D].
## [b]Note:[/b] There are several known bugs with cylinder collision shapes. Using [CapsuleShape3D] or [BoxShape3D] instead is recommended.
## [b]Performance:[/b] [CylinderShape3D] is fast to check collisions against, but it is slower than [CapsuleShape3D], [BoxShape3D], and [CylinderShape3D].
##
## @tutorial(Third Person Shooter Demo): https://godotengine.org/asset-library/asset/678
## @tutorial(3D Physics Tests Demo): https://godotengine.org/asset-library/asset/675
## @tutorial(3D Voxel Demo): https://godotengine.org/asset-library/asset/676



## The cylinder's height.
var height: float:
	get = get_height, set = set_height

## The cylinder's radius.
var radius: float:
	get = get_radius, set = set_radius




func get_height() -> float:
	return height

func set_height(value: float) -> void:
	height = value

func get_radius() -> float:
	return radius

func set_radius(value: float) -> void:
	radius = value

