extends Node3D
class_name CollisionShape3D

## A node that provides a [Shape3D] to a [CollisionObject3D] parent.
##
## A node that provides a [Shape3D] to a [CollisionObject3D] parent and allows to edit it. This can give a detection shape to an [Area3D] or turn a [PhysicsBody3D] into a solid object.
## [b]Warning:[/b] A non-uniformly scaled [CollisionShape3D] will likely not behave as expected. Make sure to keep its scale the same on all axes and adjust its [member shape] resource instead.
##
## @tutorial(Physics introduction): https://docs.godotengine.org/en/stable/tutorials/physics/physics_introduction.html
## @tutorial(3D Kinematic Character Demo): https://godotengine.org/asset-library/asset/126
## @tutorial(3D Platformer Demo): https://godotengine.org/asset-library/asset/125
## @tutorial(Third Person Shooter Demo): https://godotengine.org/asset-library/asset/678



## A disabled collision shape has no effect in the world.
var disabled: bool:
	get = is_disabled, set = set_disabled

## The actual shape owned by this collision shape.
var shape: Shape3D:
	get = get_shape, set = set_shape



## Sets the collision shape's shape to the addition of all its convexed [MeshInstance3D] siblings geometry.
func make_convex_from_siblings() -> void:
	pass;

## If this method exists within a script it will be called whenever the shape resource has been modified.
func resource_changed(resource: Resource) -> void:
	pass;


func is_disabled() -> bool:
	return disabled

func set_disabled(value: bool) -> void:
	disabled = value

func get_shape() -> Shape3D:
	return shape

func set_shape(value: Shape3D) -> void:
	shape = value

