extends Node3D
class_name CollisionPolygon3D

## A node that provides a thickened polygon shape (a prism) to a [CollisionObject3D] parent.
##
## A node that provides a thickened polygon shape (a prism) to a [CollisionObject3D] parent and allows to edit it. The polygon can be concave or convex. This can give a detection shape to an [Area3D] or turn [PhysicsBody3D] into a solid object.
## [b]Warning:[/b] A non-uniformly scaled [CollisionShape3D] will likely not behave as expected. Make sure to keep its scale the same on all axes and adjust its shape resource instead.



## Length that the resulting collision extends in either direction perpendicular to its 2D polygon.
var depth: float:
	get = get_depth, set = set_depth

## If [code]true[/code], no collision will be produced.
var disabled: bool:
	get = is_disabled, set = set_disabled

## The collision margin for the generated [Shape3D]. See [member Shape3D.margin] for more details.
var margin: float:
	get = get_margin, set = set_margin

## Array of vertices which define the 2D polygon in the local XY plane.
## [b]Note:[/b] The returned value is a copy of the original. Methods which mutate the size or properties of the return value will not impact the original polygon. To change properties of the polygon, assign it to a temporary variable and make changes before reassigning the [code]polygon[/code] member.
var polygon: PackedVector2Array:
	get = get_polygon, set = set_polygon




func get_depth() -> float:
	return depth

func set_depth(value: float) -> void:
	depth = value

func is_disabled() -> bool:
	return disabled

func set_disabled(value: bool) -> void:
	disabled = value

func get_margin() -> float:
	return margin

func set_margin(value: float) -> void:
	margin = value

func get_polygon() -> PackedVector2Array:
	return polygon

func set_polygon(value: PackedVector2Array) -> void:
	polygon = value

