extends Material
class_name CanvasItemMaterial

## A material for [CanvasItem]s.
##
## [CanvasItemMaterial]s provide a means of modifying the textures associated with a CanvasItem. They specialize in describing blend and lighting behaviors for textures. Use a [ShaderMaterial] to more fully customize a material's interactions with a [CanvasItem].


## Mix blending mode. Colors are assumed to be independent of the alpha (opacity) value.
## Additive blending mode.
## Subtractive blending mode.
## Multiplicative blending mode.
## Mix blending mode. Colors are assumed to be premultiplied by the alpha (opacity) value.
## Render the material using both light and non-light sensitive material properties.
## Render the material as if there were no light.
## Render the material as if there were only light.

#enum BlendMode
enum {
    BLEND_MODE_MIX = 0,
    BLEND_MODE_ADD = 1,
    BLEND_MODE_SUB = 2,
    BLEND_MODE_MUL = 3,
    BLEND_MODE_PREMULT_ALPHA = 4,
}
#enum LightMode
enum {
    LIGHT_MODE_NORMAL = 0,
    LIGHT_MODE_UNSHADED = 1,
    LIGHT_MODE_LIGHT_ONLY = 2,
}
## The manner in which a material's rendering is applied to underlying textures.
var blend_mode: int:
	get = get_blend_mode, set = set_blend_mode

## The manner in which material reacts to lighting.
var light_mode: int:
	get = get_light_mode, set = set_light_mode

## The number of columns in the spritesheet assigned as [Texture2D] for a [GPUParticles2D] or [CPUParticles2D].
## [b]Note:[/b] This property is only used and visible in the editor if [member particles_animation] is [code]true[/code].
var particles_anim_h_frames: int:
	get = get_particles_anim_h_frames, set = set_particles_anim_h_frames

## If [code]true[/code], the particles animation will loop.
## [b]Note:[/b] This property is only used and visible in the editor if [member particles_animation] is [code]true[/code].
var particles_anim_loop: bool:
	get = get_particles_anim_loop, set = set_particles_anim_loop

## The number of rows in the spritesheet assigned as [Texture2D] for a [GPUParticles2D] or [CPUParticles2D].
## [b]Note:[/b] This property is only used and visible in the editor if [member particles_animation] is [code]true[/code].
var particles_anim_v_frames: int:
	get = get_particles_anim_v_frames, set = set_particles_anim_v_frames

## If [code]true[/code], enable spritesheet-based animation features when assigned to [GPUParticles2D] and [CPUParticles2D] nodes. The [member ParticleProcessMaterial.anim_speed_max] or [member CPUParticles2D.anim_speed_max] should also be set to a positive value for the animation to play.
## This property (and other [code]particles_anim_*[/code] properties that depend on it) has no effect on other types of nodes.
var particles_animation: bool:
	get = get_particles_animation, set = set_particles_animation




func get_blend_mode() -> int:
	return blend_mode

func set_blend_mode(value: int) -> void:
	blend_mode = value

func get_light_mode() -> int:
	return light_mode

func set_light_mode(value: int) -> void:
	light_mode = value

func get_particles_anim_h_frames() -> int:
	return particles_anim_h_frames

func set_particles_anim_h_frames(value: int) -> void:
	particles_anim_h_frames = value

func get_particles_anim_loop() -> bool:
	return particles_anim_loop

func set_particles_anim_loop(value: bool) -> void:
	particles_anim_loop = value

func get_particles_anim_v_frames() -> int:
	return particles_anim_v_frames

func set_particles_anim_v_frames(value: int) -> void:
	particles_anim_v_frames = value

func get_particles_animation() -> bool:
	return particles_animation

func set_particles_animation(value: bool) -> void:
	particles_animation = value

