extends Occluder3D
class_name ArrayOccluder3D

## 3D polygon shape for use with occlusion culling in [OccluderInstance3D].
##
## [ArrayOccluder3D] stores an arbitrary 3D polygon shape that can be used by the engine's occlusion culling system. This is analogous to [ArrayMesh], but for occluders.
## See [OccluderInstance3D]'s documentation for instructions on setting up occlusion culling.



## The occluder's index position. Indices determine which points from the [member vertices] array should be drawn, and in which order.
## [b]Note:[/b] The occluder is always updated after setting this value. If creating occluders procedurally, consider using [method set_arrays] instead to avoid updating the occluder twice when it's created.
var indices: PackedInt32Array:
	get = get_indices, set = set_indices

## The occluder's vertex positions in local 3D coordinates.
## [b]Note:[/b] The occluder is always updated after setting this value. If creating occluders procedurally, consider using [method set_arrays] instead to avoid updating the occluder twice when it's created.
var vertices: PackedVector3Array:
	get = get_vertices, set = set_vertices



## Sets [member indices] and [member vertices], while updating the final occluder only once after both values are set.
func set_arrays(vertices: PackedVector3Array, indices: PackedInt32Array) -> void:
	pass;


func get_indices() -> PackedInt32Array:
	return indices

func set_indices(value: PackedInt32Array) -> void:
	indices = value

func get_vertices() -> PackedVector3Array:
	return vertices

func set_vertices(value: PackedVector3Array) -> void:
	vertices = value

