class_name bool

## A built-in boolean type.
##
## A [bool] is always one of two values: [code]true[/code] or [code]false[/code], similar to a switch that is either on or off. Booleans are used in programming for logic in condition statements.
## Booleans can be directly used in [code]if[/code] and [code]elif[/code] statements. You don't need to add [code]== true[/code] or [code]== false[/code]:
## [codeblocks]
## [gdscript]
## if can_shoot:
## launch_bullet()
## [/gdscript]
## [csharp]
## if (canShoot)
## {
## launchBullet();
## }
## [/csharp]
## [/codeblocks]
## Many common methods and operations return [bool]s, for example, [code]shooting_cooldown <= 0.0[/code] may evaluate to [code]true[/code] or [code]false[/code] depending on the number's value.
## [bool]s are usually used with the logical operators [code]and[/code], [code]or[/code], and [code]not[/code] to create complex conditions:
## [codeblocks]
## [gdscript]
## if bullets > 0 and not is_reloading:
## launch_bullet()
## if bullets == 0 or is_reloading:
## play_clack_sound()
## [/gdscript]
## [csharp]
## if (bullets > 0 && !isReloading)
## {
## launchBullet();
## }
## if (bullets == 0 || isReloading)
## {
## playClackSound();
## }
## [/csharp]
## [/codeblocks]




## Constructs a default-initialized [bool] set to [code]false[/code].
func bool() -> bool:
	pass;

## Constructs a [bool] as a copy of the given [bool].
func bool(from: bool) -> bool:
	pass;

## Cast a [float] value to a boolean value. This method will return [code]false[/code] if [code]0.0[/code] is passed in, and [code]true[/code] for all other values.
func bool(from: float) -> bool:
	pass;

## Cast an [int] value to a boolean value. This method will return [code]false[/code] if [code]0[/code] is passed in, and [code]true[/code] for all other values.
func bool(from: int) -> bool:
	pass;



