extends XRInterface
class_name XRInterfaceExtension

## Base class for XR interface extensions (plugins).
##
## External XR interface plugins should inherit from this class.
##
## @tutorial(XR documentation index): https://docs.godotengine.org/en/stable/tutorials/xr/index.html





## Called if interface is active and queues have been submitted.
func _end_frame() -> void:
	pass;

## Return [code]true[/code] if anchor detection is enabled for this interface.
func _get_anchor_detection_is_enabled() -> bool:
	pass;

## Returns the camera feed ID for the [CameraFeed] registered with the [CameraServer] that should be presented as the background on an AR capable device (if applicable).
func _get_camera_feed_id() -> int:
	pass;

## Returns the [Transform3D] that positions the [XRCamera3D] in the world.
func _get_camera_transform() -> Transform3D:
	pass;

## Returns the capabilities of this interface.
func _get_capabilities() -> int:
	pass;

## Return color texture into which to render (if applicable).
func _get_color_texture() -> RID:
	pass;

## Return depth texture into which to render (if applicable).
func _get_depth_texture() -> RID:
	pass;

## Returns the name of this interface.
func _get_name() -> StringName:
	pass;

## Returns an [PackedVector3Array] that denotes the play areas boundaries (if applicable).
func _get_play_area() -> PackedVector3Array:
	pass;

## Returns the [enum XRInterface.PlayAreaMode] that sets up our play area.
func _get_play_area_mode() -> int:
	pass;

## Returns the projection matrix for the given view as a [PackedFloat64Array].
func _get_projection_for_view(view: int, aspect: float, z_near: float, z_far: float) -> PackedFloat64Array:
	pass;

## Returns the size of our render target for this interface, this overrides the size of the [Viewport] marked as the xr viewport.
func _get_render_target_size() -> Vector2:
	pass;

## Returns a [PackedStringArray] with pose names configured by this interface. Note that user configuration can override this list.
func _get_suggested_pose_names(tracker_name: StringName) -> PackedStringArray:
	pass;

## Returns a [PackedStringArray] with tracker names configured by this interface. Note that user configuration can override this list.
func _get_suggested_tracker_names() -> PackedStringArray:
	pass;

## Returns a [Dictionary] with system informationr elated to this interface.
func _get_system_info() -> Dictionary:
	pass;

## Returns a [enum XRInterface.TrackingStatus] specifying the current status of our tracking.
func _get_tracking_status() -> int:
	pass;

## Returns a [Transform3D] for a given view.
func _get_transform_for_view(view: int, cam_transform: Transform3D) -> Transform3D:
	pass;

## Return velocity texture into which to render (if applicable).
func _get_velocity_texture() -> RID:
	pass;

## Returns the number of views this interface requires, 1 for mono, 2 for stereoscopic.
func _get_view_count() -> int:
	pass;

func _get_vrs_texture() -> RID:
	pass;

## Initializes the interface, returns [code]true[/code] on success.
func _initialize() -> bool:
	pass;

## Returns [code]true[/code] if this interface has been initialized.
func _is_initialized() -> bool:
	pass;

## Called after the XR [Viewport] draw logic has completed.
func _post_draw_viewport(render_target: RID, screen_rect: Rect2) -> void:
	pass;

## Called if this is our primary [XRInterfaceExtension] before we start processing a [Viewport] for every active XR [Viewport], returns [code]true[/code] if that viewport should be rendered. An XR interface may return [code]false[/code] if the user has taken off their headset and we can pause rendering.
func _pre_draw_viewport(render_target: RID) -> bool:
	pass;

## Called if this [XRInterfaceExtension] is active before rendering starts. Most XR interfaces will sync tracking at this point in time.
func _pre_render() -> void:
	pass;

## Called if this [XRInterfaceExtension] is active before our physics and game process is called. Most XR interfaces will update its [XRPositionalTracker]s at this point in time.
func _process() -> void:
	pass;

## Enables anchor detection on this interface if supported.
func _set_anchor_detection_is_enabled(enabled: bool) -> void:
	pass;

## Set the play area mode for this interface.
func _set_play_area_mode(mode: int) -> bool:
	pass;

## Returns [code]true[/code] if this interface supports this play area mode.
func _supports_play_area_mode(mode: int) -> bool:
	pass;

## Triggers a haptic pulse to be emitted on the specified tracker.
func _trigger_haptic_pulse(action_name: String, tracker_name: StringName, frequency: float, amplitude: float, duration_sec: float, delay_sec: float) -> void:
	pass;

## Uninitialize the interface.
func _uninitialize() -> void:
	pass;

## Blits our render results to screen optionally applying lens distortion. This can only be called while processing [code]_commit_views[/code].
func add_blit(render_target: RID, src_rect: Rect2, dst_rect: Rect2i, use_layer: bool, layer: int, apply_lens_distortion: bool, eye_center: Vector2, k1: float, k2: float, upscale: float, aspect_ratio: float) -> void:
	pass;

func get_color_texture() -> RID:
	pass;

func get_depth_texture() -> RID:
	pass;

## Returns a valid [RID] for a texture to which we should render the current frame if supported by the interface.
func get_render_target_texture(render_target: RID) -> RID:
	pass;

func get_velocity_texture() -> RID:
	pass;


