extends PhysicsBody3D
class_name StaticBody3D

## A 3D physics body that can't be moved by external forces. When moved manually, it doesn't affect other bodies in its path.
##
## A static 3D physics body. It can't be moved by external forces or contacts, but can be moved manually by other means such as code, [AnimationPlayer]s (with [member AnimationPlayer.playback_process_mode] set to [code]ANIMATION_PROCESS_PHYSICS[/code]), and [RemoteTransform3D].
## When [StaticBody3D] is moved, it is teleported to its new position without affecting other physics bodies in its path. If this is not desired, use [AnimatableBody3D] instead.
## [StaticBody3D] is useful for completely static objects like floors and walls, as well as moving surfaces like conveyor belts and circular revolving platforms (by using [member constant_linear_velocity] and [member constant_angular_velocity]).
##
## @tutorial(3D Physics Tests Demo): https://godotengine.org/asset-library/asset/675
## @tutorial(Third Person Shooter Demo): https://godotengine.org/asset-library/asset/678
## @tutorial(3D Voxel Demo): https://godotengine.org/asset-library/asset/676



## The body's constant angular velocity. This does not rotate the body, but affects touching bodies, as if it were rotating.
var constant_angular_velocity: Vector3:
	get = get_constant_angular_velocity, set = set_constant_angular_velocity

## The body's constant linear velocity. This does not move the body, but affects touching bodies, as if it were moving.
var constant_linear_velocity: Vector3:
	get = get_constant_linear_velocity, set = set_constant_linear_velocity

## The physics material override for the body.
## If a material is assigned to this property, it will be used instead of any other physics material, such as an inherited one.
var physics_material_override: PhysicsMaterial:
	get = get_physics_material_override, set = set_physics_material_override




func get_constant_angular_velocity() -> Vector3:
	return constant_angular_velocity

func set_constant_angular_velocity(value: Vector3) -> void:
	constant_angular_velocity = value

func get_constant_linear_velocity() -> Vector3:
	return constant_linear_velocity

func set_constant_linear_velocity(value: Vector3) -> void:
	constant_linear_velocity = value

func get_physics_material_override() -> PhysicsMaterial:
	return physics_material_override

func set_physics_material_override(value: PhysicsMaterial) -> void:
	physics_material_override = value

