extends Resource
class_name RichTextEffect

## A custom effect for a [RichTextLabel].
##
## A custom effect for a [RichTextLabel], which can be loaded in the [RichTextLabel] inspector or using [method RichTextLabel.install_effect].
## [b]Note:[/b] For a [RichTextEffect] to be usable, a BBCode tag must be defined as a member variable called [code]bbcode[/code] in the script.
## [codeblocks]
## [gdscript]
## # The RichTextEffect will be usable like this: `[example]Some text[/example]`
## var bbcode = "example"
## [/gdscript]
## [csharp]
## // The RichTextEffect will be usable like this: `[example]Some text[/example]`
## string bbcode = "example";
## [/csharp]
## [/codeblocks]
## [b]Note:[/b] As soon as a [RichTextLabel] contains at least one [RichTextEffect], it will continuously process the effect unless the project is paused. This may impact battery life negatively.
##
## @tutorial(BBCode in RichTextLabel): https://docs.godotengine.org/en/stable/tutorials/ui/bbcode_in_richtextlabel.html
## @tutorial(RichTextEffect test project (third-party)): https://github.com/Eoin-ONeill-Yokai/Godot-Rich-Text-Effect-Test-Project





## Override this method to modify properties in [param char_fx]. The method must return [code]true[/code] if the character could be transformed successfully. If the method returns [code]false[/code], it will skip transformation to avoid displaying broken text.
func _process_custom_fx(char_fx: CharFXTransform) -> bool:
	pass;


