extends Object
class_name RefCounted

## Base class for reference-counted objects.
##
## Base class for any object that keeps a reference count. [Resource] and many other helper objects inherit this class.
## Unlike other [Object] types, [RefCounted]s keep an internal reference counter so that they are automatically released when no longer in use, and only then. [RefCounted]s therefore do not need to be freed manually with [method Object.free].
## In the vast majority of use cases, instantiating and using [RefCounted]-derived types is all you need to do. The methods provided in this class are only for advanced users, and can cause issues if misused.
## [b]Note:[/b] In C#, reference-counted objects will not be freed instantly after they are no longer in use. Instead, garbage collection will run periodically and will free reference-counted objects that are no longer in use. This means that unused ones will linger on for a while before being removed.
##
## @tutorial(When and how to avoid using nodes for everything): https://docs.godotengine.org/en/stable/tutorials/best_practices/node_alternatives.html





## Returns the current reference count.
func get_reference_count() -> int:
	pass;

## Initializes the internal reference counter. Use this only if you really know what you are doing.
## Returns whether the initialization was successful.
func init_ref() -> bool:
	pass;

## Increments the internal reference counter. Use this only if you really know what you are doing.
## Returns [code]true[/code] if the increment was successful, [code]false[/code] otherwise.
func reference() -> bool:
	pass;

## Decrements the internal reference counter. Use this only if you really know what you are doing.
## Returns [code]true[/code] if the object should be freed after the decrement, [code]false[/code] otherwise.
func unreference() -> bool:
	pass;


