extends PhysicsServer2D
class_name PhysicsServer2DExtension

## Provides virtual methods that can be overridden to create custom [PhysicsServer2D] implementations.
##
## This class extends [PhysicsServer2D] by providing additional virtual methods that can be overridden. When these methods are overridden, they will be called instead of the internal methods of the physics server.
## Intended for use with GDExtension to create custom implementations of [PhysicsServer2D].





## Overridable version of [method PhysicsServer2D.area_add_shape].
func _area_add_shape(area: RID, shape: RID, transform: Transform2D, disabled: bool) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.area_attach_canvas_instance_id].
func _area_attach_canvas_instance_id(area: RID, id: int) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.area_attach_object_instance_id].
func _area_attach_object_instance_id(area: RID, id: int) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.area_clear_shapes].
func _area_clear_shapes(area: RID) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.area_create].
func _area_create() -> RID:
	pass;

## Overridable version of [method PhysicsServer2D.area_get_canvas_instance_id].
func _area_get_canvas_instance_id(area: RID) -> int:
	pass;

## Overridable version of [method PhysicsServer2D.area_get_collision_layer].
func _area_get_collision_layer(area: RID) -> int:
	pass;

## Overridable version of [method PhysicsServer2D.area_get_collision_mask].
func _area_get_collision_mask(area: RID) -> int:
	pass;

## Overridable version of [method PhysicsServer2D.area_get_object_instance_id].
func _area_get_object_instance_id(area: RID) -> int:
	pass;

## Overridable version of [method PhysicsServer2D.area_get_param].
func _area_get_param(area: RID, param: int) -> Variant:
	pass;

## Overridable version of [method PhysicsServer2D.area_get_shape].
func _area_get_shape(area: RID, shape_idx: int) -> RID:
	pass;

## Overridable version of [method PhysicsServer2D.area_get_shape_count].
func _area_get_shape_count(area: RID) -> int:
	pass;

## Overridable version of [method PhysicsServer2D.area_get_shape_transform].
func _area_get_shape_transform(area: RID, shape_idx: int) -> Transform2D:
	pass;

## Overridable version of [method PhysicsServer2D.area_get_space].
func _area_get_space(area: RID) -> RID:
	pass;

## Overridable version of [method PhysicsServer2D.area_get_transform].
func _area_get_transform(area: RID) -> Transform2D:
	pass;

## Overridable version of [method PhysicsServer2D.area_remove_shape].
func _area_remove_shape(area: RID, shape_idx: int) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.area_set_area_monitor_callback].
func _area_set_area_monitor_callback(area: RID, callback: Callable) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.area_set_collision_layer].
func _area_set_collision_layer(area: RID, layer: int) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.area_set_collision_mask].
func _area_set_collision_mask(area: RID, mask: int) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.area_set_monitor_callback].
func _area_set_monitor_callback(area: RID, callback: Callable) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.area_set_monitorable].
func _area_set_monitorable(area: RID, monitorable: bool) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.area_set_param].
func _area_set_param(area: RID, param: int, value: Variant) -> void:
	pass;

## If set to [code]true[/code], allows the area with the given [RID] to detect mouse inputs when the mouse cursor is hovering on it.
## Overridable version of [PhysicsServer2D]'s internal [code]area_set_pickable[/code] method. Corresponds to [member PhysicsBody2D.input_pickable].
func _area_set_pickable(area: RID, pickable: bool) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.area_set_shape].
func _area_set_shape(area: RID, shape_idx: int, shape: RID) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.area_set_shape_disabled].
func _area_set_shape_disabled(area: RID, shape_idx: int, disabled: bool) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.area_set_shape_transform].
func _area_set_shape_transform(area: RID, shape_idx: int, transform: Transform2D) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.area_set_space].
func _area_set_space(area: RID, space: RID) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.area_set_transform].
func _area_set_transform(area: RID, transform: Transform2D) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.body_add_collision_exception].
func _body_add_collision_exception(body: RID, excepted_body: RID) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.body_add_constant_central_force].
func _body_add_constant_central_force(body: RID, force: Vector2) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.body_add_constant_force].
func _body_add_constant_force(body: RID, force: Vector2, position: Vector2) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.body_add_constant_torque].
func _body_add_constant_torque(body: RID, torque: float) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.body_add_shape].
func _body_add_shape(body: RID, shape: RID, transform: Transform2D, disabled: bool) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.body_apply_central_force].
func _body_apply_central_force(body: RID, force: Vector2) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.body_apply_central_impulse].
func _body_apply_central_impulse(body: RID, impulse: Vector2) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.body_apply_force].
func _body_apply_force(body: RID, force: Vector2, position: Vector2) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.body_apply_impulse].
func _body_apply_impulse(body: RID, impulse: Vector2, position: Vector2) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.body_apply_torque].
func _body_apply_torque(body: RID, torque: float) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.body_apply_torque_impulse].
func _body_apply_torque_impulse(body: RID, impulse: float) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.body_attach_canvas_instance_id].
func _body_attach_canvas_instance_id(body: RID, id: int) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.body_attach_object_instance_id].
func _body_attach_object_instance_id(body: RID, id: int) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.body_clear_shapes].
func _body_clear_shapes(body: RID) -> void:
	pass;

## Given a [param body], a [param shape], and their respective parameters, this method should return [code]true[/code] if a collision between the two would occur, with additional details passed in [param results].
## Overridable version of [PhysicsServer2D]'s internal [code]shape_collide[/code] method. Corresponds to [method PhysicsDirectSpaceState2D.collide_shape].
func _body_collide_shape(body: RID, body_shape: int, shape: RID, shape_xform: Transform2D, motion: Vector2, results: void*, result_max: int, result_count: int32_t*) -> bool:
	pass;

## Overridable version of [method PhysicsServer2D.body_create].
func _body_create() -> RID:
	pass;

## Overridable version of [method PhysicsServer2D.body_get_canvas_instance_id].
func _body_get_canvas_instance_id(body: RID) -> int:
	pass;

## Returns the [RID]s of all bodies added as collision exceptions for the given [param body]. See also [method _body_add_collision_exception] and [method _body_remove_collision_exception].
## Overridable version of [PhysicsServer2D]'s internal [code]body_get_collision_exceptions[/code] method. Corresponds to [method PhysicsBody2D.get_collision_exceptions].
func _body_get_collision_exceptions(body: RID) -> Array[RID]:
	pass;

## Overridable version of [method PhysicsServer2D.body_get_collision_layer].
func _body_get_collision_layer(body: RID) -> int:
	pass;

## Overridable version of [method PhysicsServer2D.body_get_collision_mask].
func _body_get_collision_mask(body: RID) -> int:
	pass;

## Overridable version of [method PhysicsServer2D.body_get_collision_priority].
func _body_get_collision_priority(body: RID) -> float:
	pass;

## Overridable version of [method PhysicsServer2D.body_get_constant_force].
func _body_get_constant_force(body: RID) -> Vector2:
	pass;

## Overridable version of [method PhysicsServer2D.body_get_constant_torque].
func _body_get_constant_torque(body: RID) -> float:
	pass;

## Overridable version of [PhysicsServer2D]'s internal [code]body_get_contacts_reported_depth_threshold[/code] method.
## [b]Note:[/b] This method is currently unused by Godot's default physics implementation.
func _body_get_contacts_reported_depth_threshold(body: RID) -> float:
	pass;

## Overridable version of [method PhysicsServer2D.body_get_continuous_collision_detection_mode].
func _body_get_continuous_collision_detection_mode(body: RID) -> int:
	pass;

## Overridable version of [method PhysicsServer2D.body_get_direct_state].
func _body_get_direct_state(body: RID) -> PhysicsDirectBodyState2D:
	pass;

## Overridable version of [method PhysicsServer2D.body_get_max_contacts_reported].
func _body_get_max_contacts_reported(body: RID) -> int:
	pass;

## Overridable version of [method PhysicsServer2D.body_get_mode].
func _body_get_mode(body: RID) -> int:
	pass;

## Overridable version of [method PhysicsServer2D.body_get_object_instance_id].
func _body_get_object_instance_id(body: RID) -> int:
	pass;

## Overridable version of [method PhysicsServer2D.body_get_param].
func _body_get_param(body: RID, param: int) -> Variant:
	pass;

## Overridable version of [method PhysicsServer2D.body_get_shape].
func _body_get_shape(body: RID, shape_idx: int) -> RID:
	pass;

## Overridable version of [method PhysicsServer2D.body_get_shape_count].
func _body_get_shape_count(body: RID) -> int:
	pass;

## Overridable version of [method PhysicsServer2D.body_get_shape_transform].
func _body_get_shape_transform(body: RID, shape_idx: int) -> Transform2D:
	pass;

## Overridable version of [method PhysicsServer2D.body_get_space].
func _body_get_space(body: RID) -> RID:
	pass;

## Overridable version of [method PhysicsServer2D.body_get_state].
func _body_get_state(body: RID, state: int) -> Variant:
	pass;

## Overridable version of [method PhysicsServer2D.body_is_omitting_force_integration].
func _body_is_omitting_force_integration(body: RID) -> bool:
	pass;

## Overridable version of [method PhysicsServer2D.body_remove_collision_exception].
func _body_remove_collision_exception(body: RID, excepted_body: RID) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.body_remove_shape].
func _body_remove_shape(body: RID, shape_idx: int) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.body_reset_mass_properties].
func _body_reset_mass_properties(body: RID) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.body_set_axis_velocity].
func _body_set_axis_velocity(body: RID, axis_velocity: Vector2) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.body_set_collision_layer].
func _body_set_collision_layer(body: RID, layer: int) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.body_set_collision_mask].
func _body_set_collision_mask(body: RID, mask: int) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.body_set_collision_priority].
func _body_set_collision_priority(body: RID, priority: float) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.body_set_constant_force].
func _body_set_constant_force(body: RID, force: Vector2) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.body_set_constant_torque].
func _body_set_constant_torque(body: RID, torque: float) -> void:
	pass;

## Overridable version of [PhysicsServer2D]'s internal [code]body_set_contacts_reported_depth_threshold[/code] method.
## [b]Note:[/b] This method is currently unused by Godot's default physics implementation.
func _body_set_contacts_reported_depth_threshold(body: RID, threshold: float) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.body_set_continuous_collision_detection_mode].
func _body_set_continuous_collision_detection_mode(body: RID, mode: int) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.body_set_force_integration_callback].
func _body_set_force_integration_callback(body: RID, callable: Callable, userdata: Variant) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.body_set_max_contacts_reported].
func _body_set_max_contacts_reported(body: RID, amount: int) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.body_set_mode].
func _body_set_mode(body: RID, mode: int) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.body_set_omit_force_integration].
func _body_set_omit_force_integration(body: RID, enable: bool) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.body_set_param].
func _body_set_param(body: RID, param: int, value: Variant) -> void:
	pass;

## If set to [code]true[/code], allows the body with the given [RID] to detect mouse inputs when the mouse cursor is hovering on it.
## Overridable version of [PhysicsServer2D]'s internal [code]body_set_pickable[/code] method. Corresponds to [member PhysicsBody2D.input_pickable].
func _body_set_pickable(body: RID, pickable: bool) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.body_set_shape].
func _body_set_shape(body: RID, shape_idx: int, shape: RID) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.body_set_shape_as_one_way_collision].
func _body_set_shape_as_one_way_collision(body: RID, shape_idx: int, enable: bool, margin: float) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.body_set_shape_disabled].
func _body_set_shape_disabled(body: RID, shape_idx: int, disabled: bool) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.body_set_shape_transform].
func _body_set_shape_transform(body: RID, shape_idx: int, transform: Transform2D) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.body_set_space].
func _body_set_space(body: RID, space: RID) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.body_set_state].
func _body_set_state(body: RID, state: int, value: Variant) -> void:
	pass;

## Assigns the [param body] to call the given [param callable] during the synchronization phase of the loop, before [method _step] is called. See also [method _sync].
## Overridable version of [PhysicsServer2D]'s internal [code]body_set_state_sync_callback[/code] method.
func _body_set_state_sync_callback(body: RID, callable: Callable) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.body_test_motion]. Unlike the exposed implementation, this method does not receive all of the arguments inside a [PhysicsTestMotionParameters2D].
func _body_test_motion(body: RID, from: Transform2D, motion: Vector2, margin: float, collide_separation_ray: bool, recovery_as_collision: bool, result: PhysicsServer2DExtensionMotionResult*) -> bool:
	pass;

## Overridable version of [method PhysicsServer2D.capsule_shape_create].
func _capsule_shape_create() -> RID:
	pass;

## Overridable version of [method PhysicsServer2D.circle_shape_create].
func _circle_shape_create() -> RID:
	pass;

## Overridable version of [method PhysicsServer2D.concave_polygon_shape_create].
func _concave_polygon_shape_create() -> RID:
	pass;

## Overridable version of [method PhysicsServer2D.convex_polygon_shape_create].
func _convex_polygon_shape_create() -> RID:
	pass;

## Overridable version of [method PhysicsServer2D.damped_spring_joint_get_param].
func _damped_spring_joint_get_param(joint: RID, param: int) -> float:
	pass;

## Overridable version of [method PhysicsServer2D.damped_spring_joint_set_param].
func _damped_spring_joint_set_param(joint: RID, param: int, value: float) -> void:
	pass;

## Called to indicate that the physics server has stopped synchronizing. It is in the loop's iteration/physics phase, and can access physics objects even if running on a separate thread. See also [method _sync].
## Overridable version of [PhysicsServer2D]'s internal [code]end_sync[/code] method.
func _end_sync() -> void:
	pass;

## Called when the main loop finalizes to shut down the physics server. See also [method MainLoop._finalize] and [method _init].
## Overridable version of [PhysicsServer2D]'s internal [code]finish[/code] method.
func _finish() -> void:
	pass;

## Called every physics step before [method _step] to process all remaining queries.
## Overridable version of [PhysicsServer2D]'s internal [code]flush_queries[/code] method.
func _flush_queries() -> void:
	pass;

## Overridable version of [method PhysicsServer2D.free_rid].
func _free_rid(rid: RID) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.get_process_info].
func _get_process_info(process_info: int) -> int:
	pass;

## Called when the main loop is initialized and creates a new instance of this physics server. See also [method MainLoop._initialize] and [method _finish].
## Overridable version of [PhysicsServer2D]'s internal [code]init[/code] method.
func _init() -> void:
	pass;

## Overridable method that should return [code]true[/code] when the physics server is processing queries. See also [method _flush_queries].
## Overridable version of [PhysicsServer2D]'s internal [code]is_flushing_queries[/code] method.
func _is_flushing_queries() -> bool:
	pass;

## Overridable version of [method PhysicsServer2D.joint_clear].
func _joint_clear(joint: RID) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.joint_create].
func _joint_create() -> RID:
	pass;

## Overridable version of [method PhysicsServer2D.joint_disable_collisions_between_bodies].
func _joint_disable_collisions_between_bodies(joint: RID, disable: bool) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.joint_get_param].
func _joint_get_param(joint: RID, param: int) -> float:
	pass;

## Overridable version of [method PhysicsServer2D.joint_get_type].
func _joint_get_type(joint: RID) -> int:
	pass;

## Overridable version of [method PhysicsServer2D.joint_is_disabled_collisions_between_bodies].
func _joint_is_disabled_collisions_between_bodies(joint: RID) -> bool:
	pass;

## Overridable version of [method PhysicsServer2D.joint_make_damped_spring].
func _joint_make_damped_spring(joint: RID, anchor_a: Vector2, anchor_b: Vector2, body_a: RID, body_b: RID) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.joint_make_groove].
func _joint_make_groove(joint: RID, a_groove1: Vector2, a_groove2: Vector2, b_anchor: Vector2, body_a: RID, body_b: RID) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.joint_make_pin].
func _joint_make_pin(joint: RID, anchor: Vector2, body_a: RID, body_b: RID) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.joint_set_param].
func _joint_set_param(joint: RID, param: int, value: float) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.pin_joint_get_param].
func _pin_joint_get_param(joint: RID, param: int) -> float:
	pass;

## Overridable version of [method PhysicsServer2D.pin_joint_set_param].
func _pin_joint_set_param(joint: RID, param: int, value: float) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.rectangle_shape_create].
func _rectangle_shape_create() -> RID:
	pass;

## Overridable version of [method PhysicsServer2D.segment_shape_create].
func _segment_shape_create() -> RID:
	pass;

## Overridable version of [method PhysicsServer2D.separation_ray_shape_create].
func _separation_ray_shape_create() -> RID:
	pass;

## Overridable version of [method PhysicsServer2D.set_active].
func _set_active(active: bool) -> void:
	pass;

## Given two shapes and their parameters, should return [code]true[/code] if a collision between the two would occur, with additional details passed in [param results].
## Overridable version of [PhysicsServer2D]'s internal [code]shape_collide[/code] method. Corresponds to [method PhysicsDirectSpaceState2D.collide_shape].
func _shape_collide(shape_A: RID, xform_A: Transform2D, motion_A: Vector2, shape_B: RID, xform_B: Transform2D, motion_B: Vector2, results: void*, result_max: int, result_count: int32_t*) -> bool:
	pass;

## Should return the custom solver bias of the given [param shape], which defines how much bodies are forced to separate on contact when this shape is involved.
## Overridable version of [PhysicsServer2D]'s internal [code]shape_get_custom_solver_bias[/code] method. Corresponds to [member Shape2D.custom_solver_bias].
func _shape_get_custom_solver_bias(shape: RID) -> float:
	pass;

## Overridable version of [method PhysicsServer2D.shape_get_data].
func _shape_get_data(shape: RID) -> Variant:
	pass;

## Overridable version of [method PhysicsServer2D.shape_get_type].
func _shape_get_type(shape: RID) -> int:
	pass;

## Should set the custom solver bias for the given [param shape]. It defines how much bodies are forced to separate on contact.
## Overridable version of [PhysicsServer2D]'s internal [code]shape_get_custom_solver_bias[/code] method. Corresponds to [member Shape2D.custom_solver_bias].
func _shape_set_custom_solver_bias(shape: RID, bias: float) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.shape_set_data].
func _shape_set_data(shape: RID, data: Variant) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.space_create].
func _space_create() -> RID:
	pass;

## Should return how many contacts have occurred during the last physics step in the given [param space]. See also [method _space_get_contacts] and [method _space_set_debug_contacts].
## Overridable version of [PhysicsServer2D]'s internal [code]space_get_contact_count[/code] method.
func _space_get_contact_count(space: RID) -> int:
	pass;

## Should return the positions of all contacts that have occurred during the last physics step in the given [param space]. See also [method _space_get_contact_count] and [method _space_set_debug_contacts].
## Overridable version of [PhysicsServer2D]'s internal [code]space_get_contacts[/code] method.
func _space_get_contacts(space: RID) -> PackedVector2Array:
	pass;

## Overridable version of [method PhysicsServer2D.space_get_direct_state].
func _space_get_direct_state(space: RID) -> PhysicsDirectSpaceState2D:
	pass;

## Overridable version of [method PhysicsServer2D.space_get_param].
func _space_get_param(space: RID, param: int) -> float:
	pass;

## Overridable version of [method PhysicsServer2D.space_is_active].
func _space_is_active(space: RID) -> bool:
	pass;

## Overridable version of [method PhysicsServer2D.space_set_active].
func _space_set_active(space: RID, active: bool) -> void:
	pass;

## Used internally to allow the given [param space] to store contact points, up to [param max_contacts]. This is automatically set for the main [World2D]'s space when [member SceneTree.debug_collisions_hint] is [code]true[/code], or by checking "Visible Collision Shapes" in the editor. Only works in debug builds.
## Overridable version of [PhysicsServer2D]'s internal [code]space_set_debug_contacts[/code] method.
func _space_set_debug_contacts(space: RID, max_contacts: int) -> void:
	pass;

## Overridable version of [method PhysicsServer2D.space_set_param].
func _space_set_param(space: RID, param: int, value: float) -> void:
	pass;

## Called every physics step to process the physics simulation. [param step] is the time elapsed since the last physics step, in seconds. It is usually the same as [method Node.get_physics_process_delta_time].
## Overridable version of [PhysicsServer2D]'s internal [code]step[/code] method.
func _step(step: float) -> void:
	pass;

## Called to indicate that the physics server is synchronizing and cannot access physics states if running on a separate thread. See also [method _end_sync].
## Overridable version of [PhysicsServer2D]'s internal [code]sync[/code] method.
func _sync() -> void:
	pass;

## Overridable version of [method PhysicsServer2D.world_boundary_shape_create].
func _world_boundary_shape_create() -> RID:
	pass;

## Returns [code]true[/code] if the body with the given [RID] is being excluded from [method _body_test_motion]. See also [method Object.get_instance_id].
func body_test_motion_is_excluding_body(body: RID) -> bool:
	pass;

## Returns [code]true[/code] if the object with the given instance ID is being excluded from [method _body_test_motion]. See also [method Object.get_instance_id].
func body_test_motion_is_excluding_object(object: int) -> bool:
	pass;


