extends Resource
class_name PhysicsMaterial

## Holds physics-related properties of a surface, namely its roughness and bounciness.
##
## Holds physics-related properties of a surface, namely its roughness and bounciness. This class is used to apply these properties to a physics body.



## If [code]true[/code], subtracts the bounciness from the colliding object's bounciness instead of adding it.
var absorbent: bool:
	get = is_absorbent, set = set_absorbent

## The body's bounciness. Values range from [code]0[/code] (no bounce) to [code]1[/code] (full bounciness).
## [b]Note:[/b] Even with [member bounce] set to [code]1.0[/code], some energy will be lost over time due to linear and angular damping. To have a [PhysicsBody3D] that preserves all its energy over time, set [member bounce] to [code]1.0[/code], the body's linear damp mode to [b]Replace[/b] (if applicable), its linear damp to [code]0.0[/code], its angular damp mode to [b]Replace[/b] (if applicable), and its angular damp to [code]0.0[/code].
var bounce: float:
	get = get_bounce, set = set_bounce

## The body's friction. Values range from [code]0[/code] (frictionless) to [code]1[/code] (maximum friction).
var friction: float:
	get = get_friction, set = set_friction

## If [code]true[/code], the physics engine will use the friction of the object marked as "rough" when two objects collide. If [code]false[/code], the physics engine will use the lowest friction of all colliding objects instead. If [code]true[/code] for both colliding objects, the physics engine will use the highest friction.
var rough: bool:
	get = is_rough, set = set_rough




func is_absorbent() -> bool:
	return absorbent

func set_absorbent(value: bool) -> void:
	absorbent = value

func get_bounce() -> float:
	return bounce

func set_bounce(value: float) -> void:
	bounce = value

func get_friction() -> float:
	return friction

func set_friction(value: float) -> void:
	friction = value

func is_rough() -> bool:
	return rough

func set_rough(value: bool) -> void:
	rough = value

