extends Resource
class_name AudioStream

## Base class for audio streams.
##
## Base class for audio streams. Audio streams are used for sound effects and music playback, and support WAV (via [AudioStreamWAV]) and Ogg (via [AudioStreamOggVorbis]) file formats.
##
## @tutorial(Audio streams): https://docs.godotengine.org/en/stable/tutorials/audio/audio_streams.html
## @tutorial(Audio Generator Demo): https://godotengine.org/asset-library/asset/526
## @tutorial(Audio Mic Record Demo): https://godotengine.org/asset-library/asset/527
## @tutorial(Audio Spectrum Demo): https://godotengine.org/asset-library/asset/528





## Overridable method. Should return the total number of beats of this audio stream. Used by the engine to determine the position of every beat.
## Ideally, the returned value should be based off the stream's sample rate ([member AudioStreamWAV.mix_rate], for example).
func _get_beat_count() -> int:
	pass;

## Overridable method. Should return the tempo of this audio stream, in beats per minute (BPM). Used by the engine to determine the position of every beat.
## Ideally, the returned value should be based off the stream's sample rate ([member AudioStreamWAV.mix_rate], for example).
func _get_bpm() -> float:
	pass;

## Override this method to customize the returned value of [method get_length]. Should return the length of this audio stream, in seconds.
func _get_length() -> float:
	pass;

## Override this method to customize the name assigned to this audio stream. Unused by the engine.
func _get_stream_name() -> String:
	pass;

## Override this method to customize the returned value of [method instantiate_playback]. Should returned a new [AudioStreamPlayback] created when the stream is played (such as by an [AudioStreamPlayer])..
func _instantiate_playback() -> AudioStreamPlayback:
	pass;

## Override this method to customize the returned value of [method is_monophonic]. Should return [code]true[/code] if this audio stream only supports one channel.
func _is_monophonic() -> bool:
	pass;

## Returns the length of the audio stream in seconds.
func get_length() -> float:
	pass;

## Returns a newly created [AudioStreamPlayback] intended to play this audio stream. Useful for when you want to extend [method _instantiate_playback] but call [method instantiate_playback] from an internally held AudioStream subresource. An example of this can be found in the source code for [code]AudioStreamRandomPitch::instantiate_playback[/code].
func instantiate_playback() -> AudioStreamPlayback:
	pass;

## Returns [code]true[/code] if this audio stream only supports one channel ([i]monophony[/i]), or [code]false[/code] if the audio stream supports two or more channels ([i]polyphony[/i]).
func is_monophonic() -> bool:
	pass;


