extends Resource
class_name Translation

## A language translation that maps a collection of strings to their individual translations.
##
## [Translation]s are resources that can be loaded and unloaded on demand. They map a collection of strings to their individual translations, and they also provide convenience methods for pluralization.
##
## @tutorial(Internationalizing games): https://docs.godotengine.org/en/stable/tutorials/i18n/internationalizing_games.html
## @tutorial(Locales): https://docs.godotengine.org/en/stable/tutorials/i18n/locales.html



## The locale of the translation.
var locale: String:
	get = get_locale, set = set_locale



## Virtual method to override [method get_message].
func _get_message(src_message: StringName, context: StringName) -> StringName:
	pass;

## Virtual method to override [method get_plural_message].
func _get_plural_message(src_message: StringName, src_plural_message: StringName, n: int, context: StringName) -> StringName:
	pass;

## Adds a message if nonexistent, followed by its translation.
## An additional context could be used to specify the translation context or differentiate polysemic words.
func add_message(src_message: StringName, xlated_message: StringName, context: StringName = "") -> void:
	pass;

## Adds a message involving plural translation if nonexistent, followed by its translation.
## An additional context could be used to specify the translation context or differentiate polysemic words.
func add_plural_message(src_message: StringName, xlated_messages: PackedStringArray, context: StringName = "") -> void:
	pass;

## Erases a message.
func erase_message(src_message: StringName, context: StringName = "") -> void:
	pass;

## Returns a message's translation.
func get_message(src_message: StringName, context: StringName = "") -> StringName:
	pass;

## Returns the number of existing messages.
func get_message_count() -> int:
	pass;

## Returns all the messages (keys).
func get_message_list() -> PackedStringArray:
	pass;

## Returns a message's translation involving plurals.
## The number [param n] is the number or quantity of the plural object. It will be used to guide the translation system to fetch the correct plural form for the selected language.
func get_plural_message(src_message: StringName, src_plural_message: StringName, n: int, context: StringName = "") -> StringName:
	pass;

## Returns all the messages (translated text).
func get_translated_message_list() -> PackedStringArray:
	pass;


func get_locale() -> String:
	return locale

func set_locale(value: String) -> void:
	locale = value

