extends Shape2D
class_name RectangleShape2D

## A 2D rectangle shape used for physics collision.
##
## A 2D rectangle shape, intended for use in physics. Usually used to provide a shape for a [CollisionShape2D].
## [b]Performance:[/b] [RectangleShape2D] is fast to check collisions against. It is faster than [CapsuleShape2D], but slower than [CircleShape2D].
##
## @tutorial(2D Pong Demo): https://godotengine.org/asset-library/asset/121
## @tutorial(2D Kinematic Character Demo): https://godotengine.org/asset-library/asset/113



## The rectangle's width and height.
var size: Vector2:
	get = get_size, set = set_size




func get_size() -> Vector2:
	return size

func set_size(value: Vector2) -> void:
	size = value

