extends RefCounted
class_name EditorResourceConversionPlugin

## Plugin for adding custom converters from one resource format to another in the editor resource picker context menu; for example, converting a [StandardMaterial3D] to a [ShaderMaterial].
##
## [EditorResourceConversionPlugin] is invoked when the context menu is brought up for a resource in the editor inspector. Relevant conversion plugins will appear as menu options to convert the given resource to a target type.
## Below shows an example of a basic plugin that will convert an [ImageTexture] to a [PortableCompressedTexture2D].
## [codeblocks]
## [gdscript]
## extends EditorResourceConversionPlugin
## func _handles(resource: Resource):
## return resource is ImageTexture
## func _converts_to():
## return "PortableCompressedTexture2D"
## func _convert(itex: Resource):
## var ptex = PortableCompressedTexture2D.new()
## ptex.create_from_image(itex.get_image(), PortableCompressedTexture2D.COMPRESSION_MODE_LOSSLESS)
## return ptex
## [/gdscript]
## [/codeblocks]
## To use an [EditorResourceConversionPlugin], register it using the [method EditorPlugin.add_resource_conversion_plugin] method first.





## Takes an input [Resource] and converts it to the type given in [method _converts_to]. The returned [Resource] is the result of the conversion, and the input [Resource] remains unchanged.
func _convert(resource: Resource) -> Resource:
	pass;

## Returns the class name of the target type of [Resource] that this plugin converts source resources to.
func _converts_to() -> String:
	pass;

## Called to determine whether a particular [Resource] can be converted to the target resource type by this plugin.
func _handles(resource: Resource) -> bool:
	pass;


