extends RefCounted
class_name ENetConnection

## A wrapper class for an [url=http://enet.bespin.org/group__host.html]ENetHost[/url].
##
## ENet's purpose is to provide a relatively thin, simple and robust network communication layer on top of UDP (User Datagram Protocol).
##
## @tutorial(API documentation on the ENet website): http://enet.bespin.org/usergroup0.html


## No compression. This uses the most bandwidth, but has the upside of requiring the fewest CPU resources. This option may also be used to make network debugging using tools like Wireshark easier.
## ENet's built-in range encoding. Works well on small packets, but is not the most efficient algorithm on packets larger than 4 KB.
## [url=https://fastlz.org/]FastLZ[/url] compression. This option uses less CPU resources compared to [constant COMPRESS_ZLIB], at the expense of using more bandwidth.
## [url=https://www.zlib.net/]Zlib[/url] compression. This option uses less bandwidth compared to [constant COMPRESS_FASTLZ], at the expense of using more CPU resources.
## [url=https://facebook.github.io/zstd/]Zstandard[/url] compression. Note that this algorithm is not very efficient on packets smaller than 4 KB. Therefore, it's recommended to use other compression algorithms in most cases.
## An error occurred during [method service]. You will likely need to [method destroy] the host and recreate it.
## No event occurred within the specified time limit.
## A connection request initiated by enet_host_connect has completed. The array will contain the peer which successfully connected.
## A peer has disconnected. This event is generated on a successful completion of a disconnect initiated by [method ENetPacketPeer.peer_disconnect], if a peer has timed out, or if a connection request initialized by [method connect_to_host] has timed out. The array will contain the peer which disconnected. The data field contains user supplied data describing the disconnection, or 0, if none is available.
## A packet has been received from a peer. The array will contain the peer which sent the packet, the channel number upon which the packet was received, and the received packet.
## Total data sent.
## Total UDP packets sent.
## Total data received.
## Total UDP packets received.

#enum CompressionMode
enum {
    COMPRESS_NONE = 0,
    COMPRESS_RANGE_CODER = 1,
    COMPRESS_FASTLZ = 2,
    COMPRESS_ZLIB = 3,
    COMPRESS_ZSTD = 4,
}
#enum EventType
enum {
    EVENT_ERROR = -1,
    EVENT_NONE = 0,
    EVENT_CONNECT = 1,
    EVENT_DISCONNECT = 2,
    EVENT_RECEIVE = 3,
}
#enum HostStatistic
enum {
    HOST_TOTAL_SENT_DATA = 0,
    HOST_TOTAL_SENT_PACKETS = 1,
    HOST_TOTAL_RECEIVED_DATA = 2,
    HOST_TOTAL_RECEIVED_PACKETS = 3,
}


## Adjusts the bandwidth limits of a host.
func bandwidth_limit(in_bandwidth: int = 0, out_bandwidth: int = 0) -> void:
	pass;

## Queues a [param packet] to be sent to all peers associated with the host over the specified [param channel]. See [ENetPacketPeer] [code]FLAG_*[/code] constants for available packet flags.
func broadcast(channel: int, packet: PackedByteArray, flags: int) -> void:
	pass;

## Limits the maximum allowed channels of future incoming connections.
func channel_limit(limit: int) -> void:
	pass;

## Sets the compression method used for network packets. These have different tradeoffs of compression speed versus bandwidth, you may need to test which one works best for your use case if you use compression at all.
## [b]Note:[/b] Most games' network design involve sending many small packets frequently (smaller than 4 KB each). If in doubt, it is recommended to keep the default compression algorithm as it works best on these small packets.
## [b]Note:[/b] The compression mode must be set to the same value on both the server and all its clients. Clients will fail to connect if the compression mode set on the client differs from the one set on the server.
func compress(mode: int) -> void:
	pass;

## Initiates a connection to a foreign [param address] using the specified [param port] and allocating the requested [param channels]. Optional [param data] can be passed during connection in the form of a 32 bit integer.
## [b]Note:[/b] You must call either [method create_host] or [method create_host_bound] before calling this method.
func connect_to_host(address: String, port: int, channels: int = 0, data: int = 0) -> ENetPacketPeer:
	pass;

## Create an ENetHost that will allow up to [param max_peers] connected peers, each allocating up to [param max_channels] channels, optionally limiting bandwidth to [param in_bandwidth] and [param out_bandwidth].
func create_host(max_peers: int = 32, max_channels: int = 0, in_bandwidth: int = 0, out_bandwidth: int = 0) -> int:
	pass;

## Create an ENetHost like [method create_host] which is also bound to the given [param bind_address] and [param bind_port].
func create_host_bound(bind_address: String, bind_port: int, max_peers: int = 32, max_channels: int = 0, in_bandwidth: int = 0, out_bandwidth: int = 0) -> int:
	pass;

## Destroys the host and all resources associated with it.
func destroy() -> void:
	pass;

## Configure this ENetHost to use the custom Godot extension allowing DTLS encryption for ENet clients. Call this before [method connect_to_host] to have ENet connect using DTLS validating the server certificate against [param hostname]. You can pass the optional [param client_options] parameter to customize the trusted certification authorities, or disable the common name verification. See [method TLSOptions.client] and [method TLSOptions.client_unsafe].
func dtls_client_setup(hostname: String, client_options: TLSOptions = null) -> int:
	pass;

## Configure this ENetHost to use the custom Godot extension allowing DTLS encryption for ENet servers. Call this right after [method create_host_bound] to have ENet expect peers to connect using DTLS. See [method TLSOptions.server].
func dtls_server_setup(server_options: TLSOptions) -> int:
	pass;

## Sends any queued packets on the host specified to its designated peers.
func flush() -> void:
	pass;

## Returns the local port to which this peer is bound.
func get_local_port() -> int:
	pass;

## Returns the maximum number of channels allowed for connected peers.
func get_max_channels() -> int:
	pass;

## Returns the list of peers associated with this host.
## [b]Note:[/b] This list might include some peers that are not fully connected or are still being disconnected.
func get_peers() -> Array[ENetPacketPeer]:
	pass;

## Returns and resets host statistics. See [enum HostStatistic] for more info.
func pop_statistic(statistic: int) -> float:
	pass;

## Configures the DTLS server to automatically drop new connections.
## [b]Note:[/b] This method is only relevant after calling [method dtls_server_setup].
func refuse_new_connections(refuse: bool) -> void:
	pass;

## Waits for events on the host specified and shuttles packets between the host and its peers. The returned [Array] will have 4 elements. An [enum EventType], the [ENetPacketPeer] which generated the event, the event associated data (if any), the event associated channel (if any). If the generated event is [constant EVENT_RECEIVE], the received packet will be queued to the associated [ENetPacketPeer].
## Call this function regularly to handle connections, disconnections, and to receive new packets.
func service(timeout: int = 0) -> Array:
	pass;

## Sends a [param packet] toward a destination from the address and port currently bound by this ENetConnection instance.
## This is useful as it serves to establish entries in NAT routing tables on all devices between this bound instance and the public facing internet, allowing a prospective client's connection packets to be routed backward through the NAT device(s) between the public internet and this host.
## This requires forward knowledge of a prospective client's address and communication port as seen by the public internet - after any NAT devices have handled their connection request. This information can be obtained by a [url=https://en.wikipedia.org/wiki/STUN]STUN[/url] service, and must be handed off to your host by an entity that is not the prospective client. This will never work for a client behind a Symmetric NAT due to the nature of the Symmetric NAT routing algorithm, as their IP and Port cannot be known beforehand.
func socket_send(destination_address: String, destination_port: int, packet: PackedByteArray) -> void:
	pass;


