extends Container
class_name CenterContainer

## A container that keeps child controls in its center.
##
## [CenterContainer] is a container that keeps all of its child controls in its center at their minimum size.
##
## @tutorial(Using Containers): https://docs.godotengine.org/en/stable/tutorials/ui/gui_containers.html



## If [code]true[/code], centers children relative to the [CenterContainer]'s top left corner.
var use_top_left: bool:
	get = is_using_top_left, set = set_use_top_left




func is_using_top_left() -> bool:
	return use_top_left

func set_use_top_left(value: bool) -> void:
	use_top_left = value

