extends Shape2D
class_name CapsuleShape2D

## A 2D capsule shape used for physics collision.
##
## A 2D capsule shape, intended for use in physics. Usually used to provide a shape for a [CollisionShape2D].
## [b]Performance:[/b] [CapsuleShape2D] is fast to check collisions against, but it is slower than [RectangleShape2D] and [CircleShape2D].



## The capsule's height.
var height: float:
	get = get_height, set = set_height

## The capsule's radius.
var radius: float:
	get = get_radius, set = set_radius




func get_height() -> float:
	return height

func set_height(value: float) -> void:
	height = value

func get_radius() -> float:
	return radius

func set_radius(value: float) -> void:
	radius = value

