extends Shape2D
class_name WorldBoundaryShape2D

## A 2D world boundary (half-plane) shape used for physics collision.
##
## A 2D world boundary shape, intended for use in physics. [WorldBoundaryShape2D] works like an infinite straight line that forces all physics bodies to stay above it. The line's normal determines which direction is considered as "above" and in the editor, the smaller line over it represents this direction. It can for example be used for endless flat floors.



## The distance from the origin to the line, expressed in terms of [member normal] (according to its direction and magnitude). Actual absolute distance from the origin to the line can be calculated as [code]abs(distance) / normal.length()[/code].
## In the scalar equation of the line [code]ax + by = d[/code], this is [code]d[/code], while the [code](a, b)[/code] coordinates are represented by the [member normal] property.
var distance: float:
	get = get_distance, set = set_distance

## The line's normal, typically a unit vector. Its direction indicates the non-colliding half-plane. Can be of any length but zero. Defaults to [code]Vector2.UP[/code].
var normal: Vector2:
	get = get_normal, set = set_normal




func get_distance() -> float:
	return distance

func set_distance(value: float) -> void:
	distance = value

func get_normal() -> Vector2:
	return normal

func set_normal(value: Vector2) -> void:
	normal = value

