extends Slider
class_name VSlider

## A vertical slider that goes from bottom (min) to top (max).
##
## A vertical slider, used to adjust a value by moving a grabber along a vertical axis. It is a [Range]-based control and goes from bottom (min) to top (max). Note that this direction is the opposite of [VScrollBar]'s.



var size_flags_horizontal: int:
	get = get_h_size_flags, set = set_h_size_flags

var size_flags_vertical: int:
	get = get_v_size_flags, set = set_v_size_flags




func get_h_size_flags() -> int:
	return size_flags_horizontal

func set_h_size_flags(value: int) -> void:
	size_flags_horizontal = value

func get_v_size_flags() -> int:
	return size_flags_vertical

func set_v_size_flags(value: int) -> void:
	size_flags_vertical = value

