extends Object
class_name TreeItem

## An internal control for a single item inside [Tree].
##
## A single item of a [Tree] control. It can contain other [TreeItem]s as children, which allows it to create a hierarchy. It can also contain text and buttons. [TreeItem] is not a [Node], it is internal to the [Tree].
## To create a [TreeItem], use [method Tree.create_item] or [method TreeItem.create_child]. To remove a [TreeItem], use [method Object.free].
## [b]Note:[/b] The ID values used for buttons are 32-bit, unlike [int] which is always 64-bit. They go from [code]-2147483648[/code] to [code]2147483647[/code].


## Cell contains a string.
## Cell contains a checkbox.
## Cell contains a range.
## Cell contains an icon.

#enum TreeCellMode
enum {
    CELL_MODE_STRING = 0,
    CELL_MODE_CHECK = 1,
    CELL_MODE_RANGE = 2,
    CELL_MODE_ICON = 3,
    CELL_MODE_CUSTOM = 4,
}
## If [code]true[/code], the TreeItem is collapsed.
var collapsed: bool:
	get = is_collapsed, set = set_collapsed

## The custom minimum height.
var custom_minimum_height: int:
	get = get_custom_minimum_height, set = set_custom_minimum_height

## If [code]true[/code], folding is disabled for this TreeItem.
var disable_folding: bool:
	get = is_folding_disabled, set = set_disable_folding

## If [code]true[/code], the [TreeItem] is visible (default).
## Note that if a [TreeItem] is set to not be visible, none of its children will be visible either.
var visible: bool:
	get = is_visible, set = set_visible



## Adds a button with [Texture2D] [param button] at column [param column]. The [param id] is used to identify the button in the according [signal Tree.button_clicked] signal and can be different from the buttons index. If not specified, the next available index is used, which may be retrieved by calling [method get_button_count] immediately before this method. Optionally, the button can be [param disabled] and have a [param tooltip_text].
func add_button(column: int, button: Texture2D, id: int = -1, disabled: bool = false, tooltip_text: String = "") -> void:
	pass;

## Adds a previously unparented [TreeItem] as a direct child of this one. The [param child] item must not be a part of any [Tree] or parented to any [TreeItem]. See also [method remove_child].
func add_child(child: TreeItem) -> void:
	pass;

## Calls the [param method] on the actual TreeItem and its children recursively. Pass parameters as a comma separated list.
vararg func call_recursive(method: StringName) -> void:
	pass;

## Resets the background color for the given column to default.
func clear_custom_bg_color(column: int) -> void:
	pass;

## Resets the color for the given column to default.
func clear_custom_color(column: int) -> void:
	pass;

## Creates an item and adds it as a child.
## The new item will be inserted as position [param index] (the default value [code]-1[/code] means the last position), or it will be the last child if [param index] is higher than the child count.
func create_child(index: int = -1) -> TreeItem:
	pass;

## Deselects the given column.
func deselect(column: int) -> void:
	pass;

## Removes the button at index [param button_index] in column [param column].
func erase_button(column: int, button_index: int) -> void:
	pass;

## Returns the text autowrap mode in the given [param column]. By default it is [constant TextServer.AUTOWRAP_OFF].
func get_autowrap_mode(column: int) -> int:
	pass;

## Returns the [Texture2D] of the button at index [param button_index] in column [param column].
func get_button(column: int, button_index: int) -> Texture2D:
	pass;

## Returns the button index if there is a button with ID [param id] in column [param column], otherwise returns -1.
func get_button_by_id(column: int, id: int) -> int:
	pass;

## Returns the number of buttons in column [param column].
func get_button_count(column: int) -> int:
	pass;

## Returns the ID for the button at index [param button_index] in column [param column].
func get_button_id(column: int, button_index: int) -> int:
	pass;

## Returns the tooltip text for the button at index [param button_index] in column [param column].
func get_button_tooltip_text(column: int, button_index: int) -> String:
	pass;

## Returns the column's cell mode.
func get_cell_mode(column: int) -> int:
	pass;

## Returns a child item by its [param index] (see [method get_child_count]). This method is often used for iterating all children of an item.
## Negative indices access the children from the last one.
func get_child(index: int) -> TreeItem:
	pass;

## Returns the number of child items.
func get_child_count() -> int:
	pass;

## Returns an array of references to the item's children.
func get_children() -> Array[TreeItem]:
	pass;

## Returns the custom background color of column [param column].
func get_custom_bg_color(column: int) -> Color:
	pass;

## Returns the custom color of column [param column].
func get_custom_color(column: int) -> Color:
	pass;

## Returns custom font used to draw text in the column [param column].
func get_custom_font(column: int) -> Font:
	pass;

## Returns custom font size used to draw text in the column [param column].
func get_custom_font_size(column: int) -> int:
	pass;

## Returns [code]true[/code] if [code]expand_right[/code] is set.
func get_expand_right(column: int) -> bool:
	pass;

## Returns the TreeItem's first child.
func get_first_child() -> TreeItem:
	pass;

## Returns the given column's icon [Texture2D]. Error if no icon is set.
func get_icon(column: int) -> Texture2D:
	pass;

## Returns the maximum allowed width of the icon in the given [param column].
func get_icon_max_width(column: int) -> int:
	pass;

## Returns the [Color] modulating the column's icon.
func get_icon_modulate(column: int) -> Color:
	pass;

## Returns the icon [Texture2D] region as [Rect2].
func get_icon_region(column: int) -> Rect2:
	pass;

## Returns the node's order in the tree. For example, if called on the first child item the position is [code]0[/code].
func get_index() -> int:
	pass;

## Returns item's text language code.
func get_language(column: int) -> String:
	pass;

## Returns the metadata value that was set for the given column using [method set_metadata].
func get_metadata(column: int) -> Variant:
	pass;

## Returns the next sibling TreeItem in the tree or a null object if there is none.
func get_next() -> TreeItem:
	pass;

## Returns the next TreeItem in the tree (in the context of a depth-first search) or a [code]null[/code] object if there is none.
## If [param wrap] is enabled, the method will wrap around to the first element in the tree when called on the last element, otherwise it returns [code]null[/code].
func get_next_in_tree(wrap: bool = false) -> TreeItem:
	pass;

## Returns the next visible TreeItem in the tree (in the context of a depth-first search) or a [code]null[/code] object if there is none.
## If [param wrap] is enabled, the method will wrap around to the first visible element in the tree when called on the last visible element, otherwise it returns [code]null[/code].
func get_next_visible(wrap: bool = false) -> TreeItem:
	pass;

## Returns the parent TreeItem or a null object if there is none.
func get_parent() -> TreeItem:
	pass;

## Returns the previous sibling TreeItem in the tree or a null object if there is none.
func get_prev() -> TreeItem:
	pass;

## Returns the previous TreeItem in the tree (in the context of a depth-first search) or a [code]null[/code] object if there is none.
## If [param wrap] is enabled, the method will wrap around to the last element in the tree when called on the first visible element, otherwise it returns [code]null[/code].
func get_prev_in_tree(wrap: bool = false) -> TreeItem:
	pass;

## Returns the previous visible sibling TreeItem in the tree (in the context of a depth-first search) or a [code]null[/code] object if there is none.
## If [param wrap] is enabled, the method will wrap around to the last visible element in the tree when called on the first visible element, otherwise it returns [code]null[/code].
func get_prev_visible(wrap: bool = false) -> TreeItem:
	pass;

## Returns the value of a [constant CELL_MODE_RANGE] column.
func get_range(column: int) -> float:
	pass;

## Returns a dictionary containing the range parameters for a given column. The keys are "min", "max", "step", and "expr".
func get_range_config(column: int) -> Dictionary:
	pass;

func get_structured_text_bidi_override(column: int) -> int:
	pass;

func get_structured_text_bidi_override_options(column: int) -> Array:
	pass;

## Gets the suffix string shown after the column value.
func get_suffix(column: int) -> String:
	pass;

## Returns the given column's text.
func get_text(column: int) -> String:
	pass;

## Returns the given column's text alignment.
func get_text_alignment(column: int) -> int:
	pass;

## Returns item's text base writing direction.
func get_text_direction(column: int) -> int:
	pass;

## Returns the clipping behavior when the text exceeds the item's bounding rectangle in the given [param column]. By default it is [constant TextServer.OVERRUN_TRIM_ELLIPSIS].
func get_text_overrun_behavior(column: int) -> int:
	pass;

## Returns the given column's tooltip text.
func get_tooltip_text(column: int) -> String:
	pass;

## Returns the [Tree] that owns this TreeItem.
func get_tree() -> Tree:
	pass;

## Returns [code]true[/code] if this [TreeItem], or any of its descendants, is collapsed.
## If [param only_visible] is [code]true[/code] it ignores non-visible [TreeItem]s.
func is_any_collapsed(only_visible: bool = false) -> bool:
	pass;

## Returns [code]true[/code] if the button at index [param button_index] for the given [param column] is disabled.
func is_button_disabled(column: int, button_index: int) -> bool:
	pass;

## Returns [code]true[/code] if the given [param column] is checked.
func is_checked(column: int) -> bool:
	pass;

func is_custom_set_as_button(column: int) -> bool:
	pass;

## Returns [code]true[/code] if the given [param column] is multiline editable.
func is_edit_multiline(column: int) -> bool:
	pass;

## Returns [code]true[/code] if the given [param column] is editable.
func is_editable(column: int) -> bool:
	pass;

## Returns [code]true[/code] if the given [param column] is indeterminate.
func is_indeterminate(column: int) -> bool:
	pass;

## Returns [code]true[/code] if the given [param column] is selectable.
func is_selectable(column: int) -> bool:
	pass;

## Returns [code]true[/code] if the given [param column] is selected.
func is_selected(column: int) -> bool:
	pass;

## Moves this TreeItem right after the given [param item].
## [b]Note:[/b] You can't move to the root or move the root.
func move_after(item: TreeItem) -> void:
	pass;

## Moves this TreeItem right before the given [param item].
## [b]Note:[/b] You can't move to the root or move the root.
func move_before(item: TreeItem) -> void:
	pass;

## Propagates this item's checked status to its children and parents for the given [param column]. It is possible to process the items affected by this method call by connecting to [signal Tree.check_propagated_to_item]. The order that the items affected will be processed is as follows: the item invoking this method, children of that item, and finally parents of that item. If [param emit_signal] is [code]false[/code], then [signal Tree.check_propagated_to_item] will not be emitted.
func propagate_check(column: int, emit_signal: bool = true) -> void:
	pass;

## Removes the given child [TreeItem] and all its children from the [Tree]. Note that it doesn't free the item from memory, so it can be reused later (see [method add_child]). To completely remove a [TreeItem] use [method Object.free].
## [b]Note:[/b] If you want to move a child from one [Tree] to another, then instead of removing and adding it manually you can use [method move_before] or [method move_after].
func remove_child(child: TreeItem) -> void:
	pass;

## Selects the given [param column].
func select(column: int) -> void:
	pass;

## Sets the autowrap mode in the given [param column]. If set to something other than [constant TextServer.AUTOWRAP_OFF], the text gets wrapped inside the cell's bounding rectangle.
func set_autowrap_mode(column: int, autowrap_mode: int) -> void:
	pass;

## Sets the given column's button [Texture2D] at index [param button_index] to [param button].
func set_button(column: int, button_index: int, button: Texture2D) -> void:
	pass;

## Sets the given column's button color at index [param button_index] to [param color].
func set_button_color(column: int, button_index: int, color: Color) -> void:
	pass;

## If [code]true[/code], disables the button at index [param button_index] in the given [param column].
func set_button_disabled(column: int, button_index: int, disabled: bool) -> void:
	pass;

## Sets the given column's cell mode to [param mode]. See [enum TreeCellMode] constants.
func set_cell_mode(column: int, mode: int) -> void:
	pass;

## If [param checked] is [code]true[/code], the given [param column] is checked. Clears column's indeterminate status.
func set_checked(column: int, checked: bool) -> void:
	pass;

## Collapses or uncollapses this [TreeItem] and all the descendants of this item.
func set_collapsed_recursive(enable: bool) -> void:
	pass;

func set_custom_as_button(column: int, enable: bool) -> void:
	pass;

## Sets the given column's custom background color and whether to just use it as an outline.
func set_custom_bg_color(column: int, color: Color, just_outline: bool = false) -> void:
	pass;

## Sets the given column's custom color.
func set_custom_color(column: int, color: Color) -> void:
	pass;

## Sets the given column's custom draw callback to [param callback] method on [param object].
## The [param callback] should accept two arguments: the [TreeItem] that is drawn and its position and size as a [Rect2].
func set_custom_draw(column: int, object: Object, callback: StringName) -> void:
	pass;

## Sets custom font used to draw text in the given [param column].
func set_custom_font(column: int, font: Font) -> void:
	pass;

## Sets custom font size used to draw text in the given [param column].
func set_custom_font_size(column: int, font_size: int) -> void:
	pass;

## If [param multiline] is [code]true[/code], the given [param column] is multiline editable.
## [b]Note:[/b] This option only affects the type of control ([LineEdit] or [TextEdit]) that appears when editing the column. You can set multiline values with [method set_text] even if the column is not multiline editable.
func set_edit_multiline(column: int, multiline: bool) -> void:
	pass;

## If [param enabled] is [code]true[/code], the given [param column] is editable.
func set_editable(column: int, enabled: bool) -> void:
	pass;

## If [param enable] is [code]true[/code], the given [param column] is expanded to the right.
func set_expand_right(column: int, enable: bool) -> void:
	pass;

## Sets the given column's icon [Texture2D].
func set_icon(column: int, texture: Texture2D) -> void:
	pass;

## Sets the maximum allowed width of the icon in the given [param column]. This limit is applied on top of the default size of the icon and on top of [theme_item Tree.icon_max_width]. The height is adjusted according to the icon's ratio.
func set_icon_max_width(column: int, width: int) -> void:
	pass;

## Modulates the given column's icon with [param modulate].
func set_icon_modulate(column: int, modulate: Color) -> void:
	pass;

## Sets the given column's icon's texture region.
func set_icon_region(column: int, region: Rect2) -> void:
	pass;

## If [param indeterminate] is [code]true[/code], the given [param column] is marked indeterminate.
## [b]Note:[/b] If set [code]true[/code] from [code]false[/code], then column is cleared of checked status.
func set_indeterminate(column: int, indeterminate: bool) -> void:
	pass;

## Sets language code of item's text used for line-breaking and text shaping algorithms, if left empty current locale is used instead.
func set_language(column: int, language: String) -> void:
	pass;

## Sets the metadata value for the given column, which can be retrieved later using [method get_metadata]. This can be used, for example, to store a reference to the original data.
func set_metadata(column: int, meta: Variant) -> void:
	pass;

## Sets the value of a [constant CELL_MODE_RANGE] column.
func set_range(column: int, value: float) -> void:
	pass;

## Sets the range of accepted values for a column. The column must be in the [constant CELL_MODE_RANGE] mode.
## If [param expr] is [code]true[/code], the edit mode slider will use an exponential scale as with [member Range.exp_edit].
func set_range_config(column: int, min: float, max: float, step: float, expr: bool = false) -> void:
	pass;

## If [param selectable] is [code]true[/code], the given [param column] is selectable.
func set_selectable(column: int, selectable: bool) -> void:
	pass;

func set_structured_text_bidi_override(column: int, parser: int) -> void:
	pass;

func set_structured_text_bidi_override_options(column: int, args: Array) -> void:
	pass;

## Sets a string to be shown after a column's value (for example, a unit abbreviation).
func set_suffix(column: int, text: String) -> void:
	pass;

## Sets the given column's text value.
func set_text(column: int, text: String) -> void:
	pass;

## Sets the given column's text alignment. See [enum HorizontalAlignment] for possible values.
func set_text_alignment(column: int, text_alignment: int) -> void:
	pass;

## Sets item's text base writing direction.
func set_text_direction(column: int, direction: int) -> void:
	pass;

## Sets the clipping behavior when the text exceeds the item's bounding rectangle in the given [param column].
func set_text_overrun_behavior(column: int, overrun_behavior: int) -> void:
	pass;

## Sets the given column's tooltip text.
func set_tooltip_text(column: int, tooltip: String) -> void:
	pass;

func uncollapse_tree() -> void:
	pass;


func is_collapsed() -> bool:
	return collapsed

func set_collapsed(value: bool) -> void:
	collapsed = value

func get_custom_minimum_height() -> int:
	return custom_minimum_height

func set_custom_minimum_height(value: int) -> void:
	custom_minimum_height = value

func is_folding_disabled() -> bool:
	return disable_folding

func set_disable_folding(value: bool) -> void:
	disable_folding = value

func is_visible() -> bool:
	return visible

func set_visible(value: bool) -> void:
	visible = value

