class_name Rect2

## A 2D axis-aligned bounding box using floating-point coordinates.
##
## [Rect2] consists of a position, a size, and several utility functions. It is typically used for fast overlap tests.
## It uses floating-point coordinates. If you need integer coordinates, use [Rect2i] instead.
## The 3D counterpart to [Rect2] is [AABB].
## Negative values for [member size] are not supported and will not work for most methods. Use [method abs] to get a Rect2 with a positive size.
##
## @tutorial(Math documentation index): https://docs.godotengine.org/en/stable/tutorials/math/index.html
## @tutorial(Vector math): https://docs.godotengine.org/en/stable/tutorials/math/vector_math.html
## @tutorial(Advanced vector math): https://docs.godotengine.org/en/stable/tutorials/math/vectors_advanced.html



## Ending corner. This is calculated as [code]position + size[/code]. Setting this value will change the size.
var end: Vector2

## Beginning corner. Typically has values lower than [member end].
var position: Vector2

## Size from [member position] to [member end]. Typically, all components are positive.
## If the size is negative, you can use [method abs] to fix it.
var size: Vector2


## Constructs a default-initialized [Rect2] with default (zero) values of [member position] and [member size].
func Rect2() -> Rect2:
	pass;

## Constructs a [Rect2] as a copy of the given [Rect2].
func Rect2(from: Rect2) -> Rect2:
	pass;

## Constructs a [Rect2] from a [Rect2i].
func Rect2(from: Rect2i) -> Rect2:
	pass;

## Constructs a [Rect2] by position and size.
func Rect2(position: Vector2, size: Vector2) -> Rect2:
	pass;

## Constructs a [Rect2] by x, y, width, and height.
func Rect2(x: float, y: float, width: float, height: float) -> Rect2:
	pass;


## Returns a [Rect2] with equivalent position and area, modified so that the top-left corner is the origin and [code]width[/code] and [code]height[/code] are positive.
func abs() -> Rect2:
	pass;

## Returns [code]true[/code] if this [Rect2] completely encloses another one.
func encloses(b: Rect2) -> bool:
	pass;

## Returns a copy of this [Rect2] expanded to include a given point.
## [b]Example:[/b]
## [codeblocks]
## [gdscript]
## # position (-3, 2), size (1, 1)
## var rect = Rect2(Vector2(-3, 2), Vector2(1, 1))
## # position (-3, -1), size (3, 4), so we fit both rect and Vector2(0, -1)
## var rect2 = rect.expand(Vector2(0, -1))
## [/gdscript]
## [csharp]
## // position (-3, 2), size (1, 1)
## var rect = new Rect2(new Vector2(-3, 2), new Vector2(1, 1));
## // position (-3, -1), size (3, 4), so we fit both rect and Vector2(0, -1)
## var rect2 = rect.Expand(new Vector2(0, -1));
## [/csharp]
## [/codeblocks]
func expand(to: Vector2) -> Rect2:
	pass;

## Returns the area of the [Rect2]. See also [method has_area].
func get_area() -> float:
	pass;

## Returns the center of the [Rect2], which is equal to [member position] + ([member size] / 2).
func get_center() -> Vector2:
	pass;

## Returns a copy of the [Rect2] grown by the specified [param amount] on all sides.
func grow(amount: float) -> Rect2:
	pass;

## Returns a copy of the [Rect2] grown by the specified amount on each side individually.
func grow_individual(left: float, top: float, right: float, bottom: float) -> Rect2:
	pass;

## Returns a copy of the [Rect2] grown by the specified [param amount] on the specified [enum Side].
func grow_side(side: int, amount: float) -> Rect2:
	pass;

## Returns [code]true[/code] if the [Rect2] has area, and [code]false[/code] if the [Rect2] is linear, empty, or has a negative [member size]. See also [method get_area].
func has_area() -> bool:
	pass;

## Returns [code]true[/code] if the [Rect2] contains a point. By convention, the right and bottom edges of the [Rect2] are considered exclusive, so points on these edges are [b]not[/b] included.
## [b]Note:[/b] This method is not reliable for [Rect2] with a [i]negative size[/i]. Use [method abs] to get a positive sized equivalent rectangle to check for contained points.
func has_point(point: Vector2) -> bool:
	pass;

## Returns the intersection of this [Rect2] and [param b].
## If the rectangles do not intersect, an empty [Rect2] is returned.
func intersection(b: Rect2) -> Rect2:
	pass;

## Returns [code]true[/code] if the [Rect2] overlaps with [param b] (i.e. they have at least one point in common).
## If [param include_borders] is [code]true[/code], they will also be considered overlapping if their borders touch, even without intersection.
func intersects(b: Rect2, include_borders: bool = false) -> bool:
	pass;

## Returns [code]true[/code] if this [Rect2] and [param rect] are approximately equal, by calling [code]is_equal_approx[/code] on each component.
func is_equal_approx(rect: Rect2) -> bool:
	pass;

## Returns [code]true[/code] if this [Rect2] is finite, by calling [method @GlobalScope.is_finite] on each component.
func is_finite() -> bool:
	pass;

## Returns a larger [Rect2] that contains this [Rect2] and [param b].
func merge(b: Rect2) -> Rect2:
	pass;


