extends Texture3D
class_name NoiseTexture3D

## A texture filled with noise generated by a [Noise] object.
##
## Uses [FastNoiseLite] or other libraries to fill the texture data of your desired size.
## The class uses [Thread]s to generate the texture data internally, so [method Texture3D.get_data] may return [code]null[/code] if the generation process has not completed yet. In that case, you need to wait for the texture to be generated before accessing the image:
## [codeblock]
## var texture = NoiseTexture3D.new()
## texture.noise = FastNoiseLite.new()
## await texture.changed
## var data = texture.get_data()
## [/codeblock]



## A [Gradient] which is used to map the luminance of each pixel to a color value.
var color_ramp: Gradient:
	get = get_color_ramp, set = set_color_ramp

## Depth of the generated texture (in pixels).
var depth: int:
	get = get_depth, set = set_depth

## Height of the generated texture (in pixels).
var height: int:
	get = get_height, set = set_height

## If [code]true[/code], inverts the noise texture. White becomes black, black becomes white.
var invert: bool:
	get = get_invert, set = set_invert

## The instance of the [Noise] object.
var noise: Noise:
	get = get_noise, set = set_noise

## If [code]true[/code], the noise image coming from the noise generator is normalized to the range [code]0.0[/code] to [code]1.0[/code].
## Turning normalization off can affect the contrast and allows you to generate non repeating tileable noise textures.
var normalize: bool:
	get = is_normalized, set = set_normalize

## If [code]true[/code], a seamless texture is requested from the [Noise] resource.
## [b]Note:[/b] Seamless noise textures may take longer to generate and/or can have a lower contrast compared to non-seamless noise depending on the used [Noise] resource. This is because some implementations use higher dimensions for generating seamless noise.
## [b]Note:[/b] The default [FastNoiseLite] implementation uses the fallback path for seamless generation. If using a [member width], [member height] or [member depth] lower than the default, you may need to increase [member seamless_blend_skirt] to make seamless blending more effective.
var seamless: bool:
	get = get_seamless, set = set_seamless

## Used for the default/fallback implementation of the seamless texture generation. It determines the distance over which the seams are blended. High values may result in less details and contrast. See [Noise] for further details.
## [b]Note:[/b] If using a [member width], [member height] or [member depth] lower than the default, you may need to increase [member seamless_blend_skirt] to make seamless blending more effective.
var seamless_blend_skirt: float:
	get = get_seamless_blend_skirt, set = set_seamless_blend_skirt

## Width of the generated texture (in pixels).
var width: int:
	get = get_width, set = set_width




func get_color_ramp() -> Gradient:
	return color_ramp

func set_color_ramp(value: Gradient) -> void:
	color_ramp = value

func get_depth() -> int:
	return depth

func set_depth(value: int) -> void:
	depth = value

func get_height() -> int:
	return height

func set_height(value: int) -> void:
	height = value

func get_invert() -> bool:
	return invert

func set_invert(value: bool) -> void:
	invert = value

func get_noise() -> Noise:
	return noise

func set_noise(value: Noise) -> void:
	noise = value

func is_normalized() -> bool:
	return normalize

func set_normalize(value: bool) -> void:
	normalize = value

func get_seamless() -> bool:
	return seamless

func set_seamless(value: bool) -> void:
	seamless = value

func get_seamless_blend_skirt() -> float:
	return seamless_blend_skirt

func set_seamless_blend_skirt(value: float) -> void:
	seamless_blend_skirt = value

func get_width() -> int:
	return width

func set_width(value: int) -> void:
	width = value

