extends InputEventFromWindow
class_name InputEventScreenTouch

## Represents a screen touch event.
##
## Stores information about multi-touch press/release input events. Supports touch press, touch release and [member index] for multi-touch count and order.
##
## @tutorial(Using InputEvent): https://docs.godotengine.org/en/stable/tutorials/inputs/inputevent.html



## If [code]true[/code], the touch event has been canceled.
var canceled: bool:
	get = is_canceled, set = set_canceled

## If [code]true[/code], the touch's state is a double tap.
var double_tap: bool:
	get = is_double_tap, set = set_double_tap

## The touch index in the case of a multi-touch event. One index = one finger.
var index: int:
	get = get_index, set = set_index

## The touch position, in screen (global) coordinates.
var position: Vector2:
	get = get_position, set = set_position

## If [code]true[/code], the touch's state is pressed. If [code]false[/code], the touch's state is released.
var pressed: bool:
	get = is_pressed, set = set_pressed




func is_canceled() -> bool:
	return canceled

func set_canceled(value: bool) -> void:
	canceled = value

func is_double_tap() -> bool:
	return double_tap

func set_double_tap(value: bool) -> void:
	double_tap = value

func get_index() -> int:
	return index

func set_index(value: int) -> void:
	index = value

func get_position() -> Vector2:
	return position

func set_position(value: Vector2) -> void:
	position = value

func is_pressed() -> bool:
	return pressed

func set_pressed(value: bool) -> void:
	pressed = value

